/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aesh.terminal.telnet.TelnetBootstrap;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.telnet.netty.TelnetChannelHandler;

public class NettyTelnetBootstrap
extends TelnetBootstrap {
    private EventLoopGroup group = new NioEventLoopGroup();
    private ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

    @Override
    public NettyTelnetBootstrap setHost(String host) {
        return (NettyTelnetBootstrap)super.setHost(host);
    }

    @Override
    public NettyTelnetBootstrap setPort(int port) {
        return (NettyTelnetBootstrap)super.setPort(port);
    }

    @Override
    public void start(final Supplier<TelnetHandler> factory, Consumer<Throwable> doneHandler) {
        ServerBootstrap boostrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boostrap.group(this.group).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                NettyTelnetBootstrap.this.channelGroup.add((Object)ch);
                ChannelPipeline p = ch.pipeline();
                TelnetChannelHandler handler = new TelnetChannelHandler(factory);
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        boostrap.bind(this.getHost(), this.getPort()).addListener(fut -> {
            if (fut.isSuccess()) {
                doneHandler.accept(null);
            } else {
                doneHandler.accept(fut.cause());
            }
        });
    }

    @Override
    public void stop(Consumer<Throwable> doneHandler) {
        GenericFutureListener adapter = future -> doneHandler.accept(future.cause());
        this.channelGroup.close().addListener(adapter);
        this.group.shutdownGracefully();
    }
}

