/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aesh.terminal.telnet.TelnetTestBase;
import org.aesh.terminal.telnet.TelnetTtyConnection;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.junit.Test;

public abstract class TelnetTermTest
extends TelnetTestBase {
    @Test
    public void testSizeHandler() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.server.start(() -> {
            AtomicInteger count = new AtomicInteger();
            return new TelnetTtyConnection(false, false, StandardCharsets.UTF_8, conn -> conn.setSizeHandler(size -> {
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(20, size.getWidth());
                        this.assertEquals(10, size.getHeight());
                        latch1.countDown();
                        break;
                    }
                    case 1: {
                        this.assertEquals(80, size.getWidth());
                        this.assertEquals(24, size.getHeight());
                        latch2.countDown();
                        break;
                    }
                    case 2: {
                        this.assertEquals(180, size.getWidth());
                        this.assertEquals(160, size.getHeight());
                        this.testComplete();
                        break;
                    }
                    default: {
                        this.fail("Was not expecting that");
                    }
                }
            }));
        });
        WindowSizeOptionHandler optionHandler = new WindowSizeOptionHandler(20, 10, false, false, true, false);
        this.client.setOptionHandler((TelnetOptionHandler)optionHandler);
        this.client.connect("localhost", 4000);
        latch1.await(30L, TimeUnit.SECONDS);
        this.client.writeDirectAndFlush(-1, -6, 31, 0, 80, 0, 24, -1, -16);
        latch2.await(30L, TimeUnit.SECONDS);
        this.client.writeDirectAndFlush(-1, -6, 31, 0, -76, 0, -96, -1, -16);
        this.await();
    }
}

