/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet.tty;

import java.io.Closeable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aesh.terminal.Connection;
import org.aesh.terminal.telnet.TelnetClientRule;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.telnet.TelnetServerRule;
import org.aesh.terminal.telnet.TelnetTtyConnection;
import org.aesh.terminal.tty.TtyTestBase;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.junit.Rule;

public abstract class TelnetTtyTestBase
extends TtyTestBase {
    protected boolean binary;
    private WindowSizeOptionHandler wsHandler;
    @Rule
    public TelnetServerRule server = new TelnetServerRule(this.serverFactory());
    @Rule
    public TelnetClientRule client = new TelnetClientRule();

    protected abstract Function<Supplier<TelnetHandler>, Closeable> serverFactory();

    public boolean checkDisconnected() {
        return this.client.checkDisconnected();
    }

    protected void server(Consumer<Connection> onConnect) {
        this.server.start(() -> new TelnetTtyConnection(this.binary, this.binary, this.charset, onConnect));
    }

    protected void resize(int width, int height) {
    }

    protected void assertConnect(String term) throws Exception {
        this.client.setOptionHandler((TelnetOptionHandler)new EchoOptionHandler(false, false, true, true));
        if (this.binary) {
            this.client.setOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(0, false, false, true, true));
        }
        if (term != null) {
            this.client.setOptionHandler((TelnetOptionHandler)new TerminalTypeOptionHandler(term, false, false, true, false));
        }
        this.client.connect("localhost", 4000);
    }

    protected void assertWrite(String s) throws Exception {
        this.client.write(s.getBytes(this.charset));
        this.client.flush();
    }

    protected final void assertWriteln(String s) throws Exception {
        this.assertWrite(s + (this.binary ? "\r" : "\r\n"));
    }

    protected String assertReadString(int len) throws Exception {
        return this.client.assertReadString(len);
    }

    protected void assertDisconnect(boolean clean) throws Exception {
        this.client.disconnect(clean);
    }

    public void testSize() throws Exception {
        this.wsHandler = new WindowSizeOptionHandler(80, 24, false, false, true, true);
        this.client.setOptionHandler((TelnetOptionHandler)this.wsHandler);
        super.testSize();
    }

    public void testResize() throws Exception {
    }
}

