/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.http.netty.HttpRequestHandler;
import org.aesh.terminal.http.netty.TtyWebSocketFrameHandler;

public class TtyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelGroup group;
    private final Consumer<Connection> handler;

    public TtyServerInitializer(ChannelGroup group, Consumer<Connection> handler) {
        this.group = group;
        this.handler = handler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new HttpRequestHandler("/ws")});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws")});
        pipeline.addLast(new ChannelHandler[]{new TtyWebSocketFrameHandler(this.group, this.handler)});
    }
}

