/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh.netty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.terminal.ssh.netty.AsyncAuth;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.session.ServerSession;

public class AsyncUserAuthService
extends CloseableUtils.AbstractCloseable
implements Service {
    public static final int DEFAULT_MAX_AUTH_REQUESTS = 20;
    private final ServerSession session;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private AsyncAuth async;
    private int maxAuthRequests;
    private int nbAuthRequests;
    private static final Logger LOGGER = Logger.getLogger(AsyncUserAuthService.class.getName());

    public AsyncUserAuthService(Session s) throws SshException {
        ValidateUtils.checkTrue((boolean)(s instanceof ServerSession), (String)"Server side service used on client side");
        if (s.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.session = (ServerSession)s;
        this.maxAuthRequests = this.session.getIntProperty("max-auth-requests", 20);
        ServerFactoryManager manager = this.getFactoryManager();
        this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(manager.getUserAuthFactories());
        this.authMethods = new ArrayList<List<String>>();
        String mths = FactoryManagerUtils.getString((FactoryManager)manager, (String)"auth-methods");
        if (GenericUtils.isEmpty((CharSequence)mths)) {
            for (NamedFactory namedFactory : manager.getUserAuthFactories()) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
            }
        } else {
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(mthl.split(","))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                NamedFactory factory = (NamedFactory)NamedResource.Utils.findByName((String)m, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Authorized authentication methods: " + NamedResource.Utils.getNames(this.userAuthFactories));
        }
    }

    public void start() {
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void process(int cmd, Buffer buffer) throws Exception {
        Boolean authed = Boolean.FALSE;
        if (cmd == 50) {
            NamedFactory factory;
            LOGGER.fine("Received SSH_MSG_USERAUTH_REQUEST");
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
            String username = buffer.getString();
            String service = buffer.getString();
            String method = buffer.getString();
            if (this.authUserName == null || this.authService == null) {
                this.authUserName = username;
                this.authService = service;
            } else if (!this.authUserName.equals(username) || !this.authService.equals(service)) {
                this.session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
                return;
            }
            this.authMethod = method;
            if (this.nbAuthRequests++ > this.maxAuthRequests) {
                this.session.disconnect(2, "Too many authentication failures");
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Authenticating user '{" + username + "}' with service '{" + service + "}' and method '{" + method + "}'");
            }
            if ((factory = (NamedFactory)NamedResource.Utils.findByName((String)method, (Comparator)String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) != null) {
                this.currentAuth = (UserAuth)factory.create();
                try {
                    authed = this.currentAuth.auth(this.session, username, service, buffer);
                }
                catch (Exception e) {
                    if (this.asyncAuth(buffer, e)) {
                        return;
                    }
                    LOGGER.fine("Authentication failed: " + e.getMessage());
                }
            }
        } else {
            assert (this.async == null);
            if (this.currentAuth == null) {
                throw new IllegalStateException("No current authentication mechanism for cmd=" + (cmd & 0xFF));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Received authentication message: " + Integer.valueOf(cmd & 0xFF));
            }
            buffer.rpos(buffer.rpos() - 1);
            try {
                authed = this.currentAuth.next(buffer);
            }
            catch (Exception e) {
                if (this.asyncAuth(buffer, e)) {
                    return;
                }
                LOGGER.log(Level.FINE, "Failed ({}) to authenticate: " + e.getClass().getSimpleName(), e.getMessage());
            }
        }
        if (authed == null) {
            LOGGER.fine("Authentication not finished");
        } else {
            this.sendAuthenticationResult(buffer, authed);
        }
    }

    private boolean asyncAuth(Buffer buffer, Exception e) {
        if (e instanceof AsyncAuth) {
            this.async = (AsyncAuth)e;
            this.async.setListener(authenticated -> {
                this.async = null;
                try {
                    this.sendAuthenticationResult(buffer, (boolean)authenticated);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            });
            return true;
        }
        return false;
    }

    private void sendAuthenticationResult(Buffer buffer, boolean authed) throws Exception {
        if (authed) {
            LOGGER.fine("Authentication succeeded");
            String username = this.currentAuth.getUserName();
            boolean success = false;
            for (List<String> l : this.authMethods) {
                if (GenericUtils.size(l) <= 0 || !l.get(0).equals(this.authMethod)) continue;
                l.remove(0);
                success |= l.isEmpty();
            }
            if (success) {
                int n;
                ServerFactoryManager manager = this.getFactoryManager();
                Integer maxSessionCount = FactoryManagerUtils.getInteger((FactoryManager)manager, (String)"max-concurrent-sessions");
                if (maxSessionCount != null && (n = this.session.getActiveSessionCountForUser(username)) >= maxSessionCount) {
                    this.session.disconnect(7, "Too many concurrent connections (" + n + ") - max. allowed: " + maxSessionCount);
                    return;
                }
                String string = FactoryManagerUtils.getString((FactoryManager)manager, (String)"welcome-banner");
                if (string != null) {
                    buffer = this.session.createBuffer((byte)53);
                    buffer.putString(string);
                    buffer.putString("en");
                    this.session.writePacket(buffer);
                }
                buffer = this.session.createBuffer((byte)52);
                this.session.setUsername(username);
                this.session.setAuthenticated();
                this.session.startService(this.authService);
                this.session.writePacket(buffer);
                this.session.resetIdleTimeout();
                LOGGER.fine("Session {" + username + "}@{+" + this.session.getIoSession().getRemoteAddress() + "} authenticated");
            } else {
                buffer = this.session.createBuffer((byte)51);
                StringBuilder sb = new StringBuilder();
                for (List list : this.authMethods) {
                    if (GenericUtils.size((Collection)list) <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append((String)list.get(0));
                }
                buffer.putString(sb.toString());
                buffer.putBoolean(true);
                this.session.writePacket(buffer);
            }
            this.currentAuth.destroy();
            this.currentAuth = null;
        } else {
            LOGGER.fine("Authentication failed");
            buffer = this.session.createBuffer((byte)51);
            StringBuilder sb = new StringBuilder();
            for (List<String> l : this.authMethods) {
                String m;
                if (GenericUtils.size(l) <= 0 || "none".equals(m = l.get(0))) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(l.get(0));
            }
            buffer.putString(sb.toString());
            buffer.putByte((byte)0);
            this.session.writePacket(buffer);
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
        }
    }

    private ServerFactoryManager getFactoryManager() {
        return this.session.getFactoryManager();
    }
}

