/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionAlgorithm.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String makeRelative(String path, int expectedLen) {
        String relPath = path;
        if (relPath.startsWith("../")) {
            relPath = relPath.substring(3);
        }
        while (relPath.endsWith("/")) {
            relPath = relPath.substring(0, relPath.length() - 1);
        }
        while (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        String[] tokens = relPath.split("/");
        boolean containsEmpty = false;
        for (String token : tokens) {
            if (!token.equals("")) continue;
            containsEmpty = true;
            break;
        }
        if (containsEmpty) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String token : tokens) {
                if (token.equals("")) continue;
                tmp.add(token);
            }
            tokens = tmp.toArray(new String[tmp.size()]);
        }
        if (tokens.length > 3 && path.contains(":")) {
            if (tokens[tokens.length - 4].equals("tables")) {
                if (expectedLen == 0) return tokens[tokens.length - 3] + "/" + tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
                if (expectedLen == 3) {
                    return tokens[tokens.length - 3] + "/" + tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
                }
            }
            if (!tokens[tokens.length - 3].equals("tables")) throw new IllegalArgumentException(path);
            if (expectedLen == 0) return tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
            if (expectedLen != 2) throw new IllegalArgumentException(path);
            return tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
        }
        if (!(tokens.length != 3 || expectedLen != 0 && expectedLen != 3 || path.contains(":"))) {
            return tokens[0] + "/" + tokens[1] + "/" + tokens[2];
        }
        if (tokens.length != 2) throw new IllegalArgumentException(path);
        if (expectedLen != 0) {
            if (expectedLen != 2) throw new IllegalArgumentException(path);
        }
        if (path.contains(":")) throw new IllegalArgumentException(path);
        return tokens[0] + "/" + tokens[1];
    }

    private SortedMap<String, String> makeRelative(Collection<String> candidates) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (String candidate : candidates) {
            String relPath;
            try {
                relPath = this.makeRelative(candidate, 0);
            }
            catch (IllegalArgumentException iae) {
                log.warn("Ignoring invalid deletion candidate {}", (Object)candidate);
                continue;
            }
            ret.put(relPath, candidate);
        }
        return ret;
    }

    private void confirmDeletes(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws TableNotFoundException {
        boolean checkForBulkProcessingFiles;
        Iterator<String> relativePaths = candidateMap.keySet().iterator();
        for (checkForBulkProcessingFiles = false; !checkForBulkProcessingFiles && relativePaths.hasNext(); checkForBulkProcessingFiles |= relativePaths.next().toLowerCase(Locale.ENGLISH).contains("b-")) {
        }
        if (checkForBulkProcessingFiles) {
            Iterator<String> blipiter = gce.getBlipIterator();
            while (blipiter.hasNext()) {
                String blipPath = blipiter.next();
                blipPath = this.makeRelative(blipPath, 2);
                Iterator<String> tailIter = candidateMap.tailMap(blipPath).keySet().iterator();
                int count = 0;
                while (tailIter.hasNext() && tailIter.next().startsWith(blipPath)) {
                    ++count;
                    tailIter.remove();
                }
                if (count <= 0) continue;
                log.debug("Folder has bulk processing flag: {}", (Object)blipPath);
            }
        }
        Iterator iter = gce.getReferences().iterator();
        while (iter.hasNext()) {
            String dir;
            GarbageCollectionEnvironment.Reference ref = (GarbageCollectionEnvironment.Reference)iter.next();
            if (!ref.isDir) {
                String reference = ref.ref;
                if (reference.startsWith("/")) {
                    reference = "/" + ref.id + reference;
                } else if (!reference.contains(":") && !reference.startsWith("../")) {
                    throw new RuntimeException("Bad file reference " + reference);
                }
                reference = this.makeRelative(reference, 3);
                if (candidateMap.remove(reference) != null) {
                    log.debug("Candidate was still in use: {}", (Object)reference);
                }
                if (candidateMap.remove(dir = reference.substring(0, reference.lastIndexOf(47))) == null) continue;
                log.debug("Candidate was still in use: {}", (Object)reference);
                continue;
            }
            String tableID = ref.id.toString();
            dir = ref.ref;
            if (!dir.contains(":")) {
                if (!dir.startsWith("/")) {
                    throw new RuntimeException("Bad directory " + dir);
                }
                dir = "/" + tableID + dir;
            }
            if (candidateMap.remove(dir = this.makeRelative(dir, 2)) == null) continue;
            log.debug("Candidate was still in use: {}", (Object)dir);
        }
        this.confirmDeletesFromReplication(gce.getReplicationNeededIterator(), candidateMap.entrySet().iterator());
    }

    protected void confirmDeletesFromReplication(Iterator<Map.Entry<String, Replication.Status>> replicationNeededIterator, Iterator<Map.Entry<String, String>> candidateMapIterator) {
        PeekingIterator pendingReplication = Iterators.peekingIterator(replicationNeededIterator);
        PeekingIterator candidates = Iterators.peekingIterator(candidateMapIterator);
        while (pendingReplication.hasNext() && candidates.hasNext()) {
            String fullPathCandidate;
            Map.Entry pendingReplica = (Map.Entry)pendingReplication.peek();
            Map.Entry candidate = (Map.Entry)candidates.peek();
            String filePendingReplication = (String)pendingReplica.getKey();
            int comparison = filePendingReplication.compareTo(fullPathCandidate = (String)candidate.getValue());
            if (comparison < 0) {
                pendingReplication.next();
                continue;
            }
            if (comparison > 1) {
                candidates.next();
                continue;
            }
            candidates.next();
            pendingReplication.next();
            if (StatusUtil.isSafeForRemoval((Replication.Status)((Replication.Status)pendingReplica.getValue()))) continue;
            candidates.remove();
        }
    }

    private void cleanUpDeletedTableDirs(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws IOException {
        HashSet<TableId> tableIdsWithDeletes = new HashSet<TableId>();
        for (String delete : candidateMap.keySet()) {
            String[] tokens = delete.split("/");
            if (tokens.length != 2) continue;
            TableId tableId = TableId.of((String)delete.split("/")[0]);
            tableIdsWithDeletes.add(tableId);
        }
        Set<TableId> tableIdsInZookeeper = gce.getTableIDs();
        tableIdsWithDeletes.removeAll(tableIdsInZookeeper);
        for (TableId delTableId : tableIdsWithDeletes) {
            gce.deleteTableDirIfEmpty(delTableId);
        }
    }

    private boolean getCandidates(GarbageCollectionEnvironment gce, String lastCandidate, List<String> candidates) throws TableNotFoundException {
        try (TraceScope candidatesSpan = Trace.startSpan((String)"getCandidates");){
            boolean bl = gce.getCandidates(lastCandidate, candidates);
            return bl;
        }
    }

    private void confirmDeletesTrace(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws TableNotFoundException {
        try (TraceScope confirmDeletesSpan = Trace.startSpan((String)"confirmDeletes");){
            this.confirmDeletes(gce, candidateMap);
        }
    }

    private void deleteConfirmed(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws IOException, TableNotFoundException {
        try (TraceScope deleteSpan = Trace.startSpan((String)"deleteFiles");){
            gce.delete(candidateMap);
        }
        this.cleanUpDeletedTableDirs(gce, candidateMap);
    }

    public void collect(GarbageCollectionEnvironment gce) throws TableNotFoundException, IOException {
        String lastCandidate = "";
        boolean outOfMemory = true;
        while (outOfMemory) {
            ArrayList<String> candidates = new ArrayList<String>();
            outOfMemory = this.getCandidates(gce, lastCandidate, candidates);
            if (candidates.size() == 0) break;
            lastCandidate = (String)candidates.get(candidates.size() - 1);
            long origSize = candidates.size();
            gce.incrementCandidatesStat(origSize);
            SortedMap<String, String> candidateMap = this.makeRelative(candidates);
            this.confirmDeletesTrace(gce, candidateMap);
            gce.incrementInUseStat(origSize - (long)candidateMap.size());
            this.deleteConfirmed(gce, candidateMap);
        }
    }
}

