/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.miniclusterImpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterControl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.miniclusterImpl.ZooKeeperBindException;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.AccumuloStatus;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.classloader.vfs.MiniDFSUtil;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterImpl
implements AccumuloCluster {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterImpl.class);
    private boolean initialized = false;
    private Set<Pair<ServerType, Integer>> debugPorts = new HashSet<Pair<ServerType, Integer>>();
    private File zooCfgFile;
    private String dfsUri;
    private SiteConfiguration siteConfig;
    private ServerContext context;
    private Properties clientProperties;
    private MiniAccumuloConfigImpl config;
    private MiniDFSCluster miniDFS = null;
    private List<Process> cleanup = new ArrayList<Process>();
    private ExecutorService executor;
    private MiniAccumuloClusterControl clusterControl;

    File getZooCfgFile() {
        return this.zooCfgFile;
    }

    public ProcessInfo exec(Class<?> clazz, String ... args) throws IOException {
        return this.exec(clazz, (List<String>)null, args);
    }

    public ProcessInfo exec(Class<?> clazz, List<String> jvmArgs, String ... args) throws IOException {
        ArrayList<String> jvmArgs2 = new ArrayList<String>(1 + (jvmArgs == null ? 0 : jvmArgs.size()));
        jvmArgs2.add("-Xmx" + this.config.getDefaultMemory());
        if (jvmArgs != null) {
            jvmArgs2.addAll(jvmArgs);
        }
        return this._exec(clazz, jvmArgs2, args);
    }

    private String getClasspath() {
        StringBuilder classpathBuilder = new StringBuilder();
        classpathBuilder.append(this.config.getConfDir().getAbsolutePath());
        if (this.config.getHadoopConfDir() != null) {
            classpathBuilder.append(File.pathSeparator).append(this.config.getHadoopConfDir().getAbsolutePath());
        }
        if (this.config.getClasspathItems() == null) {
            String javaClassPath = System.getProperty("java.class.path");
            if (javaClassPath == null) {
                throw new IllegalStateException("java.class.path is not set");
            }
            classpathBuilder.append(File.pathSeparator).append(javaClassPath);
        } else {
            for (String s : this.config.getClasspathItems()) {
                classpathBuilder.append(File.pathSeparator).append(s);
            }
        }
        return classpathBuilder.toString();
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "PATH_TRAVERSAL_IN"}, justification="mini runs in the same security context as user providing the args")
    private ProcessInfo _exec(Class<?> clazz, List<String> extraJvmOpts, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = this.getClasspath();
        String className = clazz.getName();
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(javaBin, "-Dproc=" + clazz.getSimpleName(), "-cp", classpath));
        argList.addAll(extraJvmOpts);
        for (Map.Entry<String, String> sysProp : this.config.getSystemProperties().entrySet()) {
            argList.add(String.format("-D%s=%s", sysProp.getKey(), sysProp.getValue()));
        }
        argList.addAll(Arrays.asList("-XX:+UseConcMarkSweepGC", "-XX:CMSInitiatingOccupancyFraction=75", "-Dapple.awt.UIElement=true", "-Djava.net.preferIPv4Stack=true", "-XX:+PerfDisableSharedMem", "-XX:+AlwaysPreTouch", Main.class.getName(), className));
        argList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argList);
        builder.environment().put("ACCUMULO_HOME", this.config.getDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_LOG_DIR", this.config.getLogDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_CLIENT_CONF_PATH", this.config.getClientConfFile().getAbsolutePath());
        String ldLibraryPath = Joiner.on((String)File.pathSeparator).join((Object[])this.config.getNativeLibPaths());
        builder.environment().put("LD_LIBRARY_PATH", ldLibraryPath);
        builder.environment().put("DYLD_LIBRARY_PATH", ldLibraryPath);
        String env = System.getenv("HADOOP_HOME");
        if (env != null) {
            builder.environment().put("HADOOP_HOME", env);
        }
        if ((env = System.getenv("ZOOKEEPER_HOME")) != null) {
            builder.environment().put("ZOOKEEPER_HOME", env);
        }
        builder.environment().put("ACCUMULO_CONF_DIR", this.config.getConfDir().getAbsolutePath());
        if (this.config.getHadoopConfDir() != null) {
            builder.environment().put("HADOOP_CONF_DIR", this.config.getHadoopConfDir().getAbsolutePath());
        }
        log.debug("Starting MiniAccumuloCluster process with class: " + clazz.getSimpleName() + "\n, jvmOpts: " + extraJvmOpts + "\n, classpath: " + classpath + "\n, args: " + argList + "\n, environment: " + builder.environment());
        int hashcode = builder.hashCode();
        File stdOut = new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + hashcode + ".out");
        File stdErr = new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + hashcode + ".err");
        Process process = builder.redirectError(stdErr).redirectOutput(stdOut).start();
        this.cleanup.add(process);
        return new ProcessInfo(process, stdOut);
    }

    public ProcessInfo _exec(Class<?> clazz, ServerType serverType, Map<String, String> configOverrides, String ... args) throws IOException {
        ArrayList<String> jvmOpts = new ArrayList<String>();
        jvmOpts.add("-Xmx" + this.config.getMemory(serverType));
        if (configOverrides != null && !configOverrides.isEmpty()) {
            File siteFile = Files.createTempFile(this.config.getConfDir().toPath(), "accumulo", ".properties", new FileAttribute[0]).toFile();
            HashMap<String, String> confMap = new HashMap<String, String>();
            confMap.putAll(this.config.getSiteConfig());
            confMap.putAll(configOverrides);
            this.writeConfigProperties(siteFile, confMap);
            jvmOpts.add("-Daccumulo.properties=" + siteFile.getName());
        }
        if (this.config.isJDWPEnabled()) {
            int port = PortUtils.getRandomFreePort();
            jvmOpts.addAll(this.buildRemoteDebugParams(port));
            this.debugPorts.add((Pair<ServerType, Integer>)new Pair((Object)serverType, (Object)port));
        }
        return this._exec(clazz, jvmOpts, args);
    }

    public MiniAccumuloClusterImpl(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloClusterImpl(MiniAccumuloConfigImpl config) throws IOException {
        this.config = config.initialize();
        MiniAccumuloClusterImpl.mkdirs(config.getConfDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLogDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibExtDir());
        if (!config.useExistingInstance()) {
            if (!config.useExistingZooKeepers()) {
                MiniAccumuloClusterImpl.mkdirs(config.getZooKeeperDir());
            }
            MiniAccumuloClusterImpl.mkdirs(config.getAccumuloDir());
        }
        if (config.useMiniDFS()) {
            File nn = new File(config.getAccumuloDir(), "nn");
            MiniAccumuloClusterImpl.mkdirs(nn);
            File dn = new File(config.getAccumuloDir(), "dn");
            MiniAccumuloClusterImpl.mkdirs(dn);
            File dfs = new File(config.getAccumuloDir(), "dfs");
            MiniAccumuloClusterImpl.mkdirs(dfs);
            Configuration conf = new Configuration();
            conf.set("dfs.namenode.name.dir", nn.getAbsolutePath());
            conf.set("dfs.datanode.data.dir", dn.getAbsolutePath());
            conf.set("dfs.replication", "1");
            conf.set("dfs.namenode.replication.min", "1");
            conf.set("dfs.support.append", "true");
            conf.set("dfs.datanode.synconclose", "true");
            conf.set("dfs.datanode.data.dir.perm", MiniDFSUtil.computeDatanodeDirectoryPermission());
            String oldTestBuildData = System.setProperty("test.build.data", dfs.getAbsolutePath());
            this.miniDFS = new MiniDFSCluster.Builder(conf).build();
            if (oldTestBuildData == null) {
                System.clearProperty("test.build.data");
            } else {
                System.setProperty("test.build.data", oldTestBuildData);
            }
            this.miniDFS.waitClusterUp();
            InetSocketAddress dfsAddress = this.miniDFS.getNameNode().getNameNodeAddress();
            this.dfsUri = "hdfs://" + dfsAddress.getHostName() + ":" + dfsAddress.getPort();
            File coreFile = new File(config.getConfDir(), "core-site.xml");
            this.writeConfig(coreFile, Collections.singletonMap("fs.default.name", this.dfsUri).entrySet());
            File hdfsFile = new File(config.getConfDir(), "hdfs-site.xml");
            this.writeConfig(hdfsFile, (Iterable<Map.Entry<String, String>>)conf);
            Map<String, String> siteConfig = config.getSiteConfig();
            siteConfig.put(Property.INSTANCE_DFS_URI.getKey(), this.dfsUri);
            siteConfig.put(Property.INSTANCE_DFS_DIR.getKey(), "/accumulo");
            config.setSiteConfig(siteConfig);
        } else {
            this.dfsUri = config.useExistingInstance() ? config.getHadoopConfiguration().get("fs.defaultFS") : "file:///";
        }
        File clientConfFile = config.getClientConfFile();
        this.writeConfigProperties(clientConfFile, Maps.filterEntries(config.getSiteConfig(), v -> ClientConfiguration.ClientProperty.getPropertyByKey((String)((String)v.getKey())) != null));
        Map<String, String> clientProps = config.getClientProps();
        clientProps.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), config.getZooKeepers());
        clientProps.put(ClientProperty.INSTANCE_NAME.getKey(), config.getInstanceName());
        if (!clientProps.containsKey(ClientProperty.AUTH_TYPE.getKey())) {
            clientProps.put(ClientProperty.AUTH_TYPE.getKey(), "password");
            clientProps.put(ClientProperty.AUTH_PRINCIPAL.getKey(), config.getRootUserName());
            clientProps.put(ClientProperty.AUTH_TOKEN.getKey(), config.getRootPassword());
        }
        File clientPropsFile = config.getClientPropsFile();
        this.writeConfigProperties(clientPropsFile, clientProps);
        File siteFile = new File(config.getConfDir(), "accumulo.properties");
        this.writeConfigProperties(siteFile, config.getSiteConfig());
        this.siteConfig = new SiteConfiguration(siteFile);
        if (!config.useExistingInstance() && !config.useExistingZooKeepers()) {
            this.zooCfgFile = new File(config.getConfDir(), "zoo.cfg");
            FileWriter fileWriter = new FileWriter(this.zooCfgFile);
            Properties zooCfg = new Properties();
            zooCfg.setProperty("tickTime", "2000");
            zooCfg.setProperty("initLimit", "10");
            zooCfg.setProperty("syncLimit", "5");
            zooCfg.setProperty("clientPortAddress", "127.0.0.1");
            zooCfg.setProperty("clientPort", config.getZooKeeperPort() + "");
            zooCfg.setProperty("maxClientCnxns", "1000");
            zooCfg.setProperty("dataDir", config.getZooKeeperDir().getAbsolutePath());
            zooCfg.store(fileWriter, null);
            fileWriter.close();
        }
        this.clusterControl = new MiniAccumuloClusterControl(this);
    }

    private static void mkdirs(File dir) {
        if (!dir.mkdirs()) {
            log.warn("Unable to create {}", (Object)dir);
        }
    }

    private void writeConfig(File file, Iterable<Map.Entry<String, String>> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.append("<configuration>\n");
        for (Map.Entry<String, String> entry : settings) {
            String value = entry.getValue().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            fileWriter.append("<property><name>" + entry.getKey() + "</name><value>" + value + "</value></property>\n");
        }
        fileWriter.append("</configuration>\n");
        fileWriter.close();
    }

    private void writeConfigProperties(File file, Map<String, String> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            fileWriter.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="insecure socket used for reservation")
    public synchronized void start() throws IOException, InterruptedException {
        if (this.config.useMiniDFS() && this.miniDFS == null) {
            throw new IllegalStateException("Cannot restart mini when using miniDFS");
        }
        MiniAccumuloClusterControl control = this.getClusterControl();
        if (this.config.useExistingInstance()) {
            VolumeManager fs;
            AccumuloConfiguration acuConf = this.config.getAccumuloConfiguration();
            Configuration hadoopConf = this.config.getHadoopConfiguration();
            ConfigurationCopy cc = new ConfigurationCopy((Iterable)acuConf);
            try {
                fs = VolumeManagerImpl.get((AccumuloConfiguration)cc, (Configuration)hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = ServerUtil.getAccumuloInstanceIdPath((VolumeManager)fs);
            String instanceIdFromFile = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)cc, (Configuration)hadoopConf);
            IZooReaderWriter zrw = new ZooReaderWriterFactory().getZooReaderWriter(cc.get(Property.INSTANCE_ZK_HOST), (int)cc.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), cc.get(Property.INSTANCE_SECRET));
            String rootPath = ZooUtil.getRoot((String)instanceIdFromFile);
            String instanceName = null;
            try {
                for (String name : zrw.getChildren("/accumulo/instances")) {
                    String instanceNamePath = "/accumulo/instances/" + name;
                    byte[] bytes = zrw.getData(instanceNamePath, new Stat());
                    String iid = new String(bytes, StandardCharsets.UTF_8);
                    if (!iid.equals(instanceIdFromFile)) continue;
                    instanceName = name;
                }
            }
            catch (KeeperException e) {
                throw new RuntimeException("Unable to read instance name from zookeeper.", e);
            }
            if (instanceName == null) {
                throw new RuntimeException("Unable to read instance name from zookeeper.");
            }
            this.config.setInstanceName(instanceName);
            if (!AccumuloStatus.isAccumuloOffline((IZooReader)zrw, (String)rootPath)) {
                throw new RuntimeException("The Accumulo instance being used is already running. Aborting.");
            }
        } else {
            if (!this.initialized) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        this.stop();
                    }
                    catch (IOException e) {
                        log.error("IOException while attempting to stop the MiniAccumuloCluster.", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        log.error("The stopping of MiniAccumuloCluster was interrupted.", (Throwable)e);
                    }
                }));
            }
            if (!this.config.useExistingZooKeepers()) {
                control.start(ServerType.ZOOKEEPER);
            }
            if (!this.initialized) {
                Process initProcess;
                int ret;
                if (!this.config.useExistingZooKeepers()) {
                    long startTime = System.currentTimeMillis();
                    while (true) {
                        Socket s = null;
                        try {
                            s = new Socket("localhost", this.config.getZooKeeperPort());
                            s.setReuseAddress(true);
                            s.getOutputStream().write("ruok\n".getBytes());
                            s.getOutputStream().flush();
                            byte[] buffer = new byte[100];
                            int n = s.getInputStream().read(buffer);
                            if (n < 4 || !new String(buffer, 0, 4).equals("imok")) continue;
                        }
                        catch (Exception e) {
                            if (System.currentTimeMillis() - startTime >= this.config.getZooKeeperStartupTime()) {
                                throw new ZooKeeperBindException("Zookeeper did not start within " + this.config.getZooKeeperStartupTime() / 1000L + " seconds. Check the logs in " + this.config.getLogDir() + " for errors.  Last exception: " + e);
                            }
                            UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
                            continue;
                        }
                        finally {
                            if (s == null) continue;
                            s.close();
                            continue;
                        }
                        break;
                    }
                }
                LinkedList<String> args = new LinkedList<String>();
                args.add("--instance-name");
                args.add(this.config.getInstanceName());
                args.add("--user");
                args.add(this.config.getRootUserName());
                args.add("--clear-instance-name");
                String saslEnabled = this.config.getSiteConfig().get(Property.INSTANCE_RPC_SASL_ENABLED.getKey());
                if (saslEnabled == null || !Boolean.parseBoolean(saslEnabled)) {
                    args.add("--password");
                    args.add(this.config.getRootPassword());
                }
                if ((ret = (initProcess = this.exec(Initialize.class, args.toArray(new String[0])).getProcess()).waitFor()) != 0) {
                    throw new RuntimeException("Initialize process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
                }
                this.initialized = true;
            }
        }
        log.info("Starting MAC against instance {} and zookeeper(s) {}.", (Object)this.config.getInstanceName(), (Object)this.config.getZooKeepers());
        control.start(ServerType.TABLET_SERVER);
        int ret = 0;
        for (int i = 0; i < 5 && (ret = this.exec(Main.class, SetGoalState.class.getName(), MasterGoalState.NORMAL.toString()).getProcess().waitFor()) != 0; ++i) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (ret != 0) {
            throw new RuntimeException("Could not set master goal state, process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
        }
        control.start(ServerType.MASTER);
        control.start(ServerType.GARBAGE_COLLECTOR);
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    private List<String> buildRemoteDebugParams(int port) {
        return Arrays.asList("-Xdebug", String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%d", port));
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        return this.debugPorts;
    }

    List<ProcessReference> references(Process ... procs) {
        ArrayList<ProcessReference> result = new ArrayList<ProcessReference>();
        for (Process proc : procs) {
            result.add(new ProcessReference(proc));
        }
        return result;
    }

    public Map<ServerType, Collection<ProcessReference>> getProcesses() {
        HashMap<ServerType, Collection<ProcessReference>> result = new HashMap<ServerType, Collection<ProcessReference>>();
        MiniAccumuloClusterControl control = this.getClusterControl();
        result.put(ServerType.MASTER, this.references(control.masterProcess));
        result.put(ServerType.TABLET_SERVER, this.references(control.tabletServerProcesses.toArray(new Process[0])));
        if (control.zooKeeperProcess != null) {
            result.put(ServerType.ZOOKEEPER, this.references(control.zooKeeperProcess));
        }
        if (control.gcProcess != null) {
            result.put(ServerType.GARBAGE_COLLECTOR, this.references(control.gcProcess));
        }
        return result;
    }

    public void killProcess(ServerType type, ProcessReference proc) throws ProcessNotFoundException, InterruptedException {
        this.getClusterControl().killProcess(type, proc);
    }

    @Override
    public String getInstanceName() {
        return this.config.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.config.getZooKeepers();
    }

    @Override
    public synchronized ServerContext getServerContext() {
        if (this.context == null) {
            this.context = new ServerContext(this.siteConfig);
        }
        return this.context;
    }

    @Override
    public synchronized void stop() throws IOException, InterruptedException {
        if (this.executor == null) {
            return;
        }
        MiniAccumuloClusterControl control = this.getClusterControl();
        control.stop(ServerType.GARBAGE_COLLECTOR, null);
        control.stop(ServerType.MASTER, null);
        control.stop(ServerType.TABLET_SERVER, null);
        control.stop(ServerType.ZOOKEEPER, null);
        if (this.executor != null) {
            List<Runnable> tasksRemaining = this.executor.shutdownNow();
            if (!tasksRemaining.isEmpty()) {
                log.warn("Unexpectedly had {} task(s) remaining in threadpool for execution when being stopped", (Object)tasksRemaining.size());
            }
            this.executor = null;
        }
        if (this.config.useMiniDFS() && this.miniDFS != null) {
            this.miniDFS.shutdown();
        }
        for (Process p : this.cleanup) {
            p.destroy();
            p.waitFor();
        }
        this.miniDFS = null;
    }

    public MiniAccumuloConfigImpl getConfig() {
        return this.config;
    }

    @Override
    public AccumuloClient createAccumuloClient(String user, AuthenticationToken token) {
        return (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).as((CharSequence)user, token).build();
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return ClientConfiguration.fromMap(this.config.getSiteConfig()).withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers());
    }

    @Override
    public synchronized Properties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = (Properties)Accumulo.newClientProperties().from(this.config.getClientPropsFile().toPath()).build();
        }
        return this.clientProperties;
    }

    @Override
    public FileSystem getFileSystem() {
        try {
            return FileSystem.get((URI)new URI(this.dfsUri), (Configuration)new Configuration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    protected void setShutdownExecutor(ExecutorService svc) {
        this.executor = svc;
    }

    @VisibleForTesting
    protected ExecutorService getShutdownExecutor() {
        return this.executor;
    }

    int stopProcessWithTimeout(Process proc, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<Integer> future = new FutureTask<Integer>(() -> {
            proc.destroy();
            return proc.waitFor();
        });
        this.executor.execute(future);
        return future.get(timeout, unit);
    }

    /*
     * Loose catch block
     */
    public MasterMonitorInfo getMasterMonitorInfo() throws AccumuloException, AccumuloSecurityException {
        MasterClientService.Client client = null;
        while (true) {
            MasterMonitorInfo masterMonitorInfo;
            AccumuloClient c;
            block16: {
                block15: {
                    c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
                    client = MasterClient.getConnectionWithRetry((ClientContext)((ClientContext)c));
                    masterMonitorInfo = client.getMasterStats(TraceUtil.traceInfo(), ((ClientContext)c).rpcCreds());
                    if (c == null) break block15;
                    c.close();
                }
                if (client == null) break block16;
                MasterClient.close((MasterClientService.Iface)client);
            }
            return masterMonitorInfo;
            {
                catch (Throwable throwable) {
                    try {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ThriftSecurityException exception) {
                        throw new AccumuloSecurityException(exception);
                    }
                    catch (ThriftNotActiveServiceException e) {
                        log.debug("Contacted a Master which is no longer active, retrying");
                        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                        if (client == null) continue;
                        MasterClient.close((MasterClientService.Iface)client);
                        continue;
                    }
                    catch (TException exception) {
                        try {
                            throw new AccumuloException((Throwable)exception);
                        }
                        catch (Throwable throwable3) {
                            if (client != null) {
                                MasterClient.close(client);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            break;
        }
    }

    public synchronized MiniDFSCluster getMiniDfs() {
        return this.miniDFS;
    }

    @Override
    public MiniAccumuloClusterControl getClusterControl() {
        return this.clusterControl;
    }

    @Override
    public Path getTemporaryPath() {
        if (this.config.useMiniDFS()) {
            return new Path("/tmp/");
        }
        File tmp = new File(this.config.getDir(), "tmp");
        MiniAccumuloClusterImpl.mkdirs(tmp);
        return new Path(tmp.toString());
    }

    @Override
    public AccumuloConfiguration getSiteConfiguration() {
        return new ConfigurationCopy(Iterables.concat((Iterable)DefaultConfiguration.getInstance(), this.config.getSiteConfig().entrySet()));
    }

    @Override
    public String getAccumuloPropertiesPath() {
        return new File(this.config.getConfDir(), "accumulo.properties").toString();
    }

    @Override
    public String getClientPropsPath() {
        return this.config.getClientPropsFile().getAbsolutePath();
    }

    public static class ProcessInfo {
        private final Process process;
        private final File stdOut;

        public ProcessInfo(Process process, File stdOut) {
            this.process = process;
            this.stdOut = stdOut;
        }

        public Process getProcess() {
            return this.process;
        }

        public String readStdOut() {
            String string;
            FileInputStream in = new FileInputStream(this.stdOut);
            try {
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((InputStream)in).close();
            return string;
        }
    }
}

