/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster.standalone;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.RemoteShell;
import org.apache.accumulo.cluster.RemoteShellOptions;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.manager.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.server.util.Admin;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneClusterControl
implements ClusterControl {
    private static final Logger log = LoggerFactory.getLogger(StandaloneClusterControl.class);
    private static final String ACCUMULO_SERVICE_SCRIPT = "accumulo-service";
    private static final String ACCUMULO_SCRIPT = "accumulo";
    private static final String MANAGER_HOSTS_FILE = "managers";
    private static final String GC_HOSTS_FILE = "gc";
    private static final String TSERVER_HOSTS_FILE = "tservers";
    private static final String MONITOR_HOSTS_FILE = "monitor";
    String accumuloHome;
    String clientAccumuloConfDir;
    String serverAccumuloConfDir;
    private String clientCmdPrefix;
    private String serverCmdPrefix;
    protected RemoteShellOptions options = new RemoteShellOptions();
    protected String accumuloServicePath;
    protected String accumuloPath;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public StandaloneClusterControl(String accumuloHome, String clientAccumuloConfDir, String serverAccumuloConfDir, String clientCmdPrefix, String serverCmdPrefix) {
        this.accumuloHome = accumuloHome;
        this.clientAccumuloConfDir = clientAccumuloConfDir;
        this.serverAccumuloConfDir = serverAccumuloConfDir;
        this.clientCmdPrefix = clientCmdPrefix;
        this.serverCmdPrefix = serverCmdPrefix;
        File bin = new File(accumuloHome, "bin");
        this.accumuloServicePath = new File(bin, ACCUMULO_SERVICE_SCRIPT).getAbsolutePath();
        this.accumuloPath = new File(bin, ACCUMULO_SCRIPT).getAbsolutePath();
    }

    protected Map.Entry<Integer, String> exec(String hostname, String[] command) throws IOException {
        RemoteShell shell = new RemoteShell(hostname, command, this.options);
        try {
            shell.execute();
        }
        catch (Shell.ExitCodeException e) {
            String output = shell.getOutput();
            Shell.ExitCodeException ece = new Shell.ExitCodeException(e.getExitCode(), "stderr: " + e.getMessage() + ", stdout: " + output);
            log.error("Failed to run command", (Throwable)ece);
            return Maps.immutableEntry((Object)e.getExitCode(), (Object)output);
        }
        return Maps.immutableEntry((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    @Override
    public int exec(Class<?> clz, String[] args) throws IOException {
        return this.execWithStdout(clz, args).getKey();
    }

    @Override
    public Map.Entry<Integer, String> execWithStdout(Class<?> clz, String[] args) throws IOException {
        String manager = this.getHosts(MANAGER_HOSTS_FILE).get(0);
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(this.clientCmdPrefix);
        cmd.add(this.accumuloPath);
        cmd.add(clz.getName());
        for (String arg : args) {
            cmd.add("'" + arg + "'");
        }
        log.info("Running: '{}' on {}", (Object)this.sanitize(String.join((CharSequence)" ", cmd)), (Object)this.sanitize(manager));
        return this.exec(manager, cmd.toArray(new String[cmd.size()]));
    }

    private String sanitize(String msg) {
        return msg.replaceAll("[\r\n]", "");
    }

    @Override
    public void adminStopAll() throws IOException {
        String manager = this.getHosts(MANAGER_HOSTS_FILE).get(0);
        String[] cmd = new String[]{this.serverCmdPrefix, this.accumuloPath, Admin.class.getName(), "stopAll"};
        Map.Entry<Integer, String> pair = this.exec(manager, cmd);
        if (pair.getKey() != 0) {
            throw new IOException("stopAll did not finish successfully, retcode=" + pair.getKey() + ", stdout=" + pair.getValue());
        }
    }

    public void setGoalState(String goalState) throws IOException {
        Objects.requireNonNull(goalState, "Goal state must not be null");
        Preconditions.checkArgument((ManagerGoalState.valueOf((String)goalState) != null ? 1 : 0) != 0, (Object)("Unknown goal state: " + goalState));
        String manager = this.getHosts(MANAGER_HOSTS_FILE).get(0);
        String[] cmd = new String[]{this.serverCmdPrefix, this.accumuloPath, SetGoalState.class.getName(), goalState};
        Map.Entry<Integer, String> pair = this.exec(manager, cmd);
        if (pair.getKey() != 0) {
            throw new IOException("SetGoalState did not finish successfully, retcode=" + pair.getKey() + ", stdout=" + pair.getValue());
        }
    }

    @Override
    public void startAllServers(ServerType server) throws IOException {
        switch (server) {
            case TABLET_SERVER: {
                for (String tserver : this.getHosts(TSERVER_HOSTS_FILE)) {
                    this.start(server, tserver);
                }
                break;
            }
            case MASTER: 
            case MANAGER: {
                for (String manager : this.getHosts(MANAGER_HOSTS_FILE)) {
                    this.start(server, manager);
                }
                break;
            }
            case GARBAGE_COLLECTOR: {
                List<String> hosts = this.getHosts(GC_HOSTS_FILE);
                if (hosts.isEmpty()) {
                    hosts = this.getHosts(MANAGER_HOSTS_FILE);
                    if (hosts.isEmpty()) {
                        throw new IOException("Found hosts to run garbage collector on");
                    }
                    hosts = Collections.singletonList(hosts.get(0));
                }
                for (String gc : hosts) {
                    this.start(server, gc);
                }
                break;
            }
            case MONITOR: {
                for (String monitor : this.getHosts(MONITOR_HOSTS_FILE)) {
                    this.start(server, monitor);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Could not start servers for " + server);
            }
        }
    }

    @Override
    public void start(ServerType server, String hostname) throws IOException {
        String[] cmd = new String[]{this.serverCmdPrefix, this.accumuloServicePath, this.getProcessString(server), "start"};
        Map.Entry<Integer, String> pair = this.exec(hostname, cmd);
        if (pair.getKey() != 0) {
            throw new IOException("Start " + server + " on " + hostname + " failed for execute successfully");
        }
    }

    @Override
    public void stopAllServers(ServerType server) throws IOException {
        switch (server) {
            case TABLET_SERVER: {
                for (String tserver : this.getHosts(TSERVER_HOSTS_FILE)) {
                    this.stop(server, tserver);
                }
                break;
            }
            case MASTER: 
            case MANAGER: {
                for (String manager : this.getHosts(MANAGER_HOSTS_FILE)) {
                    this.stop(server, manager);
                }
                break;
            }
            case GARBAGE_COLLECTOR: {
                for (String gc : this.getHosts(GC_HOSTS_FILE)) {
                    this.stop(server, gc);
                }
                break;
            }
            case MONITOR: {
                for (String monitor : this.getHosts(MONITOR_HOSTS_FILE)) {
                    this.stop(server, monitor);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Could not start servers for " + server);
            }
        }
    }

    @Override
    public void stop(ServerType server, String hostname) throws IOException {
        this.kill(server, hostname);
    }

    @Override
    public void signal(ServerType server, String hostname, String signal) throws IOException {
        String pid = this.getPid(server, this.accumuloHome, hostname);
        if (pid.trim().isEmpty()) {
            log.debug("Found no processes for {} on {}", (Object)this.sanitize(server.prettyPrint()), (Object)this.sanitize(hostname));
            return;
        }
        boolean isSignalNumber = false;
        try {
            Integer.parseInt(signal);
            isSignalNumber = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String[] stopCmd = isSignalNumber ? new String[]{this.serverCmdPrefix, "kill", "-" + signal, pid} : new String[]{this.serverCmdPrefix, "kill", "-s", signal, pid};
        Map.Entry<Integer, String> pair = this.exec(hostname, stopCmd);
        if (pair.getKey() != 0) {
            throw new IOException("Signal " + signal + " to " + server + " on " + hostname + " failed for execute successfully. stdout=" + pair.getValue());
        }
    }

    @Override
    public void suspend(ServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGSTOP");
    }

    @Override
    public void resume(ServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGCONT");
    }

    @Override
    public void kill(ServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGKILL");
    }

    protected String getPid(ServerType server, String accumuloHome, String hostname) throws IOException {
        String[] getPidCommand = this.getPidCommand(server, accumuloHome);
        Map.Entry<Integer, String> ret = this.exec(hostname, getPidCommand);
        if (ret.getKey() != 0) {
            throw new IOException("Could not locate PID for " + this.getProcessString(server) + " on " + hostname);
        }
        return ret.getValue();
    }

    protected String[] getPidCommand(ServerType server, String accumuloHome) {
        return new String[]{"ps", "aux", "|", "fgrep", accumuloHome, "|", "fgrep", this.getProcessString(server), "|", "fgrep", "-v", "grep", "|", "fgrep", "-v", "ssh", "|", "awk", "'{print \\$2}'", "|", "head", "-1", "|", "tr", "-d", "'\\n'"};
    }

    protected String getProcessString(ServerType server) {
        switch (server) {
            case TABLET_SERVER: {
                return "tserver";
            }
            case GARBAGE_COLLECTOR: {
                return GC_HOSTS_FILE;
            }
            case MASTER: 
            case MANAGER: {
                return "manager";
            }
            case MONITOR: {
                return MONITOR_HOSTS_FILE;
            }
        }
        throw new UnsupportedOperationException("Unhandled ServerType " + server);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    protected File getClientConfDir() {
        File confDir = new File(this.clientAccumuloConfDir);
        if (!confDir.exists() || !confDir.isDirectory()) {
            throw new IllegalStateException("Accumulo client conf dir does not exist or is not a directory: " + confDir);
        }
        return confDir;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    protected File getServerConfDir() {
        File confDir = new File(this.serverAccumuloConfDir);
        if (!confDir.exists() || !confDir.isDirectory()) {
            throw new IllegalStateException("Accumulo server conf dir does not exist or is not a directory: " + confDir);
        }
        return confDir;
    }

    protected List<String> getHosts(String fn) throws IOException {
        return this.getHosts(new File(this.getServerConfDir(), fn));
    }

    protected List<String> getHosts(File f) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> hosts = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                hosts.add(line);
            }
            ArrayList<String> arrayList = hosts;
            return arrayList;
        }
    }

    @Override
    public void startCompactors(Class<? extends Compactor> compactor, int limit, String queueName) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void startCoordinator(Class<? extends CompactionCoordinator> coordinator) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

