/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.accumulo.monitor.rest.Totals;
import org.apache.accumulo.monitor.rest.logs.DeadLoggerList;
import org.apache.accumulo.monitor.rest.master.MasterInformation;
import org.apache.accumulo.monitor.rest.tables.TableInformationList;
import org.apache.accumulo.monitor.rest.tservers.BadTabletServers;
import org.apache.accumulo.monitor.rest.tservers.DeadServerList;
import org.apache.accumulo.monitor.rest.tservers.ServersShuttingDown;
import org.apache.accumulo.monitor.rest.tservers.TabletServer;

@XmlRootElement(name="stats")
public class SummaryInformation {
    public List<TabletServer> servers = new ArrayList<TabletServer>();
    public String masterGoalState;
    public String masterState;
    public BadTabletServers badTabletServers;
    public ServersShuttingDown tabletServersShuttingDown;
    public Integer unassignedTablets;
    public DeadServerList deadTabletServers;
    public DeadLoggerList deadLoggers;
    public TableInformationList tables;
    public Totals totals;

    public SummaryInformation() {
    }

    public SummaryInformation(int size, MasterInformation info, TableInformationList tablesList) {
        this.servers = new ArrayList<TabletServer>(size);
        this.masterGoalState = info.masterGoalState;
        this.masterState = info.masterState;
        this.badTabletServers = info.badTabletServers;
        this.tabletServersShuttingDown = info.tabletServersShuttingDown;
        this.unassignedTablets = info.unassignedTablets;
        this.deadTabletServers = info.deadTabletServers;
        this.deadLoggers = info.deadLoggers;
        this.tables = tablesList;
        this.totals = new Totals(info.ingestrate, info.queryrate, info.numentries);
    }

    public void addTabletServer(TabletServer tablet) {
        this.servers.add(tablet);
    }
}

