/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.logs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.monitor.rest.logs.LogEvent;
import org.apache.accumulo.server.monitor.DedupedLogEvent;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.spi.LoggingEvent;

@Path(value="/logs")
@Produces(value={"application/json", "application/xml"})
public class LogResource {
    @GET
    public List<LogEvent> getRecentLogs() {
        List dedupedLogEvents = LogService.getInstance().getEvents();
        ArrayList<LogEvent> logEvents = new ArrayList<LogEvent>(dedupedLogEvents.size());
        for (DedupedLogEvent dev : dedupedLogEvents) {
            LoggingEvent ev = dev.getEvent();
            Object application = ev.getMDC("application");
            if (application == null) {
                application = "";
            }
            String msg = ev.getMessage().toString();
            msg = StringUtils.abbreviate((String)this.sanitize(msg), (int)300);
            String[] stacktrace = ev.getThrowableStrRep();
            if (stacktrace != null) {
                for (int i = 0; i < stacktrace.length; ++i) {
                    stacktrace[i] = this.sanitize(stacktrace[i]);
                }
            }
            logEvents.add(new LogEvent(ev.getTimeStamp(), application, dev.getCount(), ev.getLevel().toString(), msg.trim(), stacktrace));
        }
        return logEvents;
    }

    private String sanitize(String s) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int type = Character.getType(c);
            boolean notPrintable = type == 0 || type == 13 || type == 6 || type == 18;
            text.append(notPrintable ? (char)'?' : (char)c);
        }
        return text.toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @POST
    public void clearLogs() {
        LogService.getInstance().clear();
    }
}

