/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.master;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.logs.DeadLoggerInformation;
import org.apache.accumulo.monitor.rest.logs.DeadLoggerList;
import org.apache.accumulo.monitor.rest.master.MasterInformation;
import org.apache.accumulo.monitor.rest.tservers.BadTabletServerInformation;
import org.apache.accumulo.monitor.rest.tservers.BadTabletServers;
import org.apache.accumulo.monitor.rest.tservers.DeadServerInformation;
import org.apache.accumulo.monitor.rest.tservers.DeadServerList;
import org.apache.accumulo.monitor.rest.tservers.ServerShuttingDownInformation;
import org.apache.accumulo.monitor.rest.tservers.ServersShuttingDown;
import org.apache.accumulo.server.master.state.TabletServerState;

@Path(value="/master")
@Produces(value={"application/json", "application/xml"})
public class MasterResource {
    public static final String NO_MASTERS = "No Masters running";
    @Inject
    private Monitor monitor;

    @GET
    public MasterInformation getTables() {
        return MasterResource.getTables(this.monitor);
    }

    public static MasterInformation getTables(Monitor monitor) {
        MasterInformation masterInformation;
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi != null) {
            GCStatus gcStatusObj = monitor.getGcStatus();
            String gcStatus = "Waiting";
            String label = "";
            if (gcStatusObj != null) {
                long start = 0L;
                if (gcStatusObj.current.started != 0L || gcStatusObj.currentLog.started != 0L) {
                    start = Math.max(gcStatusObj.current.started, gcStatusObj.currentLog.started);
                    label = "Running";
                } else if (gcStatusObj.lastLog.finished != 0L) {
                    start = gcStatusObj.lastLog.finished;
                }
                if (start != 0L) {
                    gcStatus = String.valueOf(start);
                }
            } else {
                gcStatus = "Down";
            }
            ArrayList<String> tservers = new ArrayList<String>();
            for (TabletServerStatus up : mmi.tServerInfo) {
                tservers.add(up.name);
            }
            for (DeadServer down : mmi.deadTabletServers) {
                tservers.add(down.server);
            }
            List masters = monitor.getContext().getMasterLocations();
            String master = masters.size() == 0 ? "Down" : AddressUtil.parseAddress((String)((String)masters.get(0)), (boolean)false).getHost();
            int onlineTabletServers = mmi.tServerInfo.size();
            int totalTabletServers = tservers.size();
            int tablets = monitor.getTotalTabletCount();
            int unassignedTablets = mmi.unassignedTablets;
            long entries = monitor.getTotalEntries();
            double ingest = monitor.getTotalIngestRate();
            double entriesRead = monitor.getTotalScanRate();
            double entriesReturned = monitor.getTotalQueryRate();
            long holdTime = monitor.getTotalHoldTime();
            double osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            int tables = monitor.getTotalTables();
            int deadTabletServers = mmi.deadTabletServers.size();
            long lookups = monitor.getTotalLookups();
            long uptime = System.currentTimeMillis() - monitor.getStartTime();
            masterInformation = new MasterInformation(master, onlineTabletServers, totalTabletServers, gcStatus, tablets, unassignedTablets, entries, ingest, entriesRead, entriesReturned, holdTime, osLoad, tables, deadTabletServers, lookups, uptime, label, MasterResource.getGoalState(monitor), MasterResource.getState(monitor), MasterResource.getNumBadTservers(monitor), MasterResource.getServersShuttingDown(monitor), MasterResource.getDeadTservers(monitor), MasterResource.getDeadLoggers(monitor));
        } else {
            masterInformation = new MasterInformation();
        }
        return masterInformation;
    }

    public static String getState(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return NO_MASTERS;
        }
        return mmi.state.toString();
    }

    public static String getGoalState(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return NO_MASTERS;
        }
        return mmi.goalState.name();
    }

    public static DeadServerList getDeadTservers(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new DeadServerList();
        }
        DeadServerList deadServers = new DeadServerList();
        for (DeadServer dead : mmi.deadTabletServers) {
            deadServers.addDeadServer(new DeadServerInformation(dead.server, dead.lastStatus, dead.status));
        }
        return deadServers;
    }

    public static DeadLoggerList getDeadLoggers(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new DeadLoggerList();
        }
        DeadLoggerList deadLoggers = new DeadLoggerList();
        for (DeadServer dead : mmi.deadTabletServers) {
            deadLoggers.addDeadLogger(new DeadLoggerInformation(dead.server, dead.lastStatus, dead.status));
        }
        return deadLoggers;
    }

    public static BadTabletServers getNumBadTservers(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new BadTabletServers();
        }
        Map badServers = mmi.getBadTServers();
        if (badServers == null || badServers.isEmpty()) {
            return new BadTabletServers();
        }
        BadTabletServers readableBadServers = new BadTabletServers();
        for (Map.Entry badServer : badServers.entrySet()) {
            try {
                TabletServerState state = TabletServerState.getStateById((byte)((Byte)badServer.getValue()));
                readableBadServers.addBadServer(new BadTabletServerInformation((String)badServer.getKey(), state.name()));
            }
            catch (IndexOutOfBoundsException e) {
                readableBadServers.addBadServer(new BadTabletServerInformation((String)badServer.getKey(), "Unknown state"));
            }
        }
        return readableBadServers;
    }

    public static ServersShuttingDown getServersShuttingDown(Monitor monitor) {
        MasterMonitorInfo mmi = monitor.getMmi();
        ServersShuttingDown servers = new ServersShuttingDown();
        if (mmi == null) {
            return servers;
        }
        for (String server : mmi.serversShuttingDown) {
            servers.addServerShuttingDown(new ServerShuttingDownInformation(server));
        }
        return servers;
    }
}

