/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.trace;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.trace.AddlInformation;
import org.apache.accumulo.monitor.rest.trace.AnnotationInformation;
import org.apache.accumulo.monitor.rest.trace.DataInformation;
import org.apache.accumulo.monitor.rest.trace.RecentTracesInformation;
import org.apache.accumulo.monitor.rest.trace.RecentTracesList;
import org.apache.accumulo.monitor.rest.trace.TraceInformation;
import org.apache.accumulo.monitor.rest.trace.TraceList;
import org.apache.accumulo.monitor.rest.trace.TraceType;
import org.apache.accumulo.monitor.rest.trace.TracesForTypeInformation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.tracer.SpanTree;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.Annotation;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;

@Path(value="/trace")
@Produces(value={"application/json", "application/xml"})
public class TracesResource {
    @Inject
    private Monitor monitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="summary/{minutes}")
    @GET
    public RecentTracesList getTraces(@DefaultValue(value="10") @PathParam(value="minutes") @NotNull @Min(value=0L) @Max(value=2592000L) @NotNull @Min(value=0L) @Max(value=2592000L) int minutes) throws Exception {
        RecentTracesList recentTraces = new RecentTracesList();
        Pair<AccumuloClient, UserGroupInformation> pair = this.getClient();
        AccumuloClient client = (AccumuloClient)pair.getFirst();
        if (client == null) {
            return recentTraces;
        }
        try {
            Scanner scanner = this.getScanner(client);
            if (scanner == null) {
                RecentTracesList recentTracesList = recentTraces;
                return recentTracesList;
            }
            Range range = this.getRangeForTrace(minutes);
            scanner.setRange(range);
            TreeMap<String, RecentTracesInformation> summary = new TreeMap<String, RecentTracesInformation>();
            if (pair.getSecond() != null) {
                ((UserGroupInformation)pair.getSecond()).doAs(() -> {
                    this.parseSpans(scanner, summary);
                    return null;
                });
            } else {
                this.parseSpans(scanner, summary);
            }
            for (Map.Entry entry : summary.entrySet()) {
                RecentTracesInformation stat = (RecentTracesInformation)entry.getValue();
                recentTraces.addTrace(stat);
            }
            RecentTracesList recentTracesList = recentTraces;
            return recentTracesList;
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="listType/{type}/{minutes}")
    @GET
    public TraceType getTracesType(@PathParam(value="type") @NotNull @Pattern(regexp="(?:)(.*)") @NotNull @Pattern(regexp="(?:)(.*)") String type, @PathParam(value="minutes") @Min(value=0L) @Max(value=2592000L) @Min(value=0L) @Max(value=2592000L) int minutes) throws Exception {
        TraceType typeTraces = new TraceType(type);
        Pair<AccumuloClient, UserGroupInformation> pair = this.getClient();
        AccumuloClient client = (AccumuloClient)pair.getFirst();
        if (client == null) {
            return typeTraces;
        }
        try {
            Scanner scanner = this.getScanner(client);
            if (scanner == null) {
                TraceType traceType = typeTraces;
                return traceType;
            }
            Range range = this.getRangeForTrace(minutes);
            scanner.setRange(range);
            if (pair.getSecond() != null) {
                ((UserGroupInformation)pair.getSecond()).doAs(() -> {
                    for (Map.Entry entry : scanner) {
                        RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
                        if (!span.description.equals(type)) continue;
                        typeTraces.addTrace(new TracesForTypeInformation(span));
                    }
                    return null;
                });
            } else {
                for (Map.Entry entry : scanner) {
                    RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
                    if (!span.description.equals(type)) continue;
                    typeTraces.addTrace(new TracesForTypeInformation(span));
                }
            }
            TraceType traceType = typeTraces;
            return traceType;
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="show/{id}")
    @GET
    public TraceList getTracesType(@PathParam(value="id") @NotNull @Pattern(regexp="\\w+") @NotNull @Pattern(regexp="\\w+") String id) throws Exception {
        TraceList traces = new TraceList(id);
        Pair<AccumuloClient, UserGroupInformation> pair = this.getClient();
        AccumuloClient client = (AccumuloClient)pair.getFirst();
        if (client == null) {
            return traces;
        }
        try {
            Scanner scanner = this.getScanner(client);
            if (scanner == null) {
                TraceList traceList = traces;
                return traceList;
            }
            Range range = new Range(new Text(id));
            scanner.setRange(range);
            SpanTree tree = new SpanTree();
            long start = pair.getSecond() != null ? ((Long)((UserGroupInformation)pair.getSecond()).doAs(() -> this.addSpans(scanner, tree, Long.MAX_VALUE))).longValue() : this.addSpans(scanner, tree, Long.MAX_VALUE);
            traces.addStartTime(start);
            long finalStart = start;
            Set visited = tree.visit((level, node) -> traces.addTrace(TracesResource.addTraceInformation(level, node, finalStart)));
            tree.nodes.keySet().removeAll(visited);
            if (!tree.nodes.isEmpty()) {
                for (RemoteSpan span : TraceDump.sortByStart(tree.nodes.values())) {
                    traces.addTrace(TracesResource.addTraceInformation(0, span, finalStart));
                }
            }
            TraceList traceList = traces;
            return traceList;
        }
        finally {
            client.close();
        }
    }

    private static TraceInformation addTraceInformation(int level, RemoteSpan node, long finalStart) {
        boolean hasData = node.data != null && !node.data.isEmpty();
        boolean hasAnnotations = node.annotations != null && !node.annotations.isEmpty();
        AddlInformation addlData = new AddlInformation();
        if (hasData || hasAnnotations) {
            if (hasData) {
                for (Map.Entry entry : node.data.entrySet()) {
                    DataInformation data = new DataInformation((String)entry.getKey(), (String)entry.getValue());
                    addlData.addData(data);
                }
            }
            if (hasAnnotations) {
                for (Annotation annotation : node.annotations) {
                    AnnotationInformation annotations = new AnnotationInformation(annotation.getMsg(), annotation.getTime() - finalStart);
                    addlData.addAnnotations(annotations);
                }
            }
        }
        return new TraceInformation(level, node.stop - node.start, node.start - finalStart, node.spanId, node.svc + "@" + node.sender, node.description, addlData);
    }

    protected Range getRangeForTrace(long minutesSince) {
        long endTime = System.currentTimeMillis();
        long millisSince = minutesSince * 60L * 1000L;
        if (millisSince < minutesSince) {
            millisSince = endTime;
        }
        long startTime = endTime - millisSince;
        String startHexTime = Long.toHexString(startTime);
        String endHexTime = Long.toHexString(endTime);
        if (startHexTime.length() < endHexTime.length()) {
            StringUtils.leftPad((String)startHexTime, (int)endHexTime.length(), (char)'0');
        }
        return new Range(new Text("start:" + startHexTime), new Text("start:" + endHexTime));
    }

    private void parseSpans(Scanner scanner, Map<String, RecentTracesInformation> summary) {
        for (Map.Entry entry : scanner) {
            RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
            RecentTracesInformation stats = summary.get(span.description);
            if (stats == null) {
                stats = new RecentTracesInformation(span.description);
                summary.put(span.description, stats);
            }
            stats.addSpan(span);
        }
    }

    protected Pair<AccumuloClient, UserGroupInformation> getClient() {
        AccumuloClient client;
        Object props;
        PasswordToken at;
        String principal;
        AccumuloConfiguration conf = this.monitor.getContext().getConfiguration();
        boolean saslEnabled = conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED);
        UserGroupInformation traceUgi = null;
        Map loginMap = conf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX);
        String keytab = (String)loginMap.get(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey() + "keytab");
        if (keytab == null || keytab.length() == 0) {
            keytab = conf.getPath(Property.GENERAL_KERBEROS_KEYTAB);
        }
        if (saslEnabled && keytab != null) {
            principal = SecurityUtil.getServerPrincipal((String)conf.get(Property.TRACE_USER));
            try {
                traceUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to login as trace user", e);
            }
        } else {
            principal = conf.get(Property.TRACE_USER);
        }
        if (!saslEnabled) {
            if (loginMap.isEmpty()) {
                Property p = Property.TRACE_PASSWORD;
                at = new PasswordToken(conf.get(p).getBytes(StandardCharsets.UTF_8));
            } else {
                props = new AuthenticationToken.Properties();
                int prefixLength = Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey().length();
                for (Map.Entry entry : loginMap.entrySet()) {
                    props.put(((String)entry.getKey()).substring(prefixLength), (CharSequence)entry.getValue());
                }
                AuthenticationToken token = (AuthenticationToken)Property.createInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.TRACE_TOKEN_TYPE, AuthenticationToken.class, (Object)new PasswordToken());
                token.init(props);
                at = token;
            }
        } else {
            at = null;
        }
        props = this.monitor.getContext().getProperties();
        if (traceUgi != null) {
            try {
                client = (AccumuloClient)traceUgi.doAs(() -> TracesResource.lambda$getClient$4((Properties)props, principal));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to obtain scanner", e);
            }
        } else {
            if (at == null) {
                throw new AssertionError((Object)"AuthenticationToken should not be null");
            }
            client = (AccumuloClient)Accumulo.newClient().from((Properties)props).as((CharSequence)principal, (AuthenticationToken)at).build();
        }
        return new Pair((Object)client, (Object)traceUgi);
    }

    private Scanner getScanner(AccumuloClient client) throws AccumuloException {
        try {
            AccumuloConfiguration conf = this.monitor.getContext().getConfiguration();
            String table = conf.get(Property.TRACE_TABLE);
            if (!client.tableOperations().exists(table)) {
                return null;
            }
            return client.createScanner(table);
        }
        catch (AccumuloSecurityException | TableNotFoundException ex) {
            return null;
        }
    }

    private long addSpans(Scanner scanner, SpanTree tree, long start) {
        for (Map.Entry entry : scanner) {
            RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
            tree.addNode(span);
            start = Math.min(start, span.start);
        }
        return start;
    }

    private static /* synthetic */ AccumuloClient lambda$getClient$4(Properties props, String principal) throws Exception {
        KerberosToken token = new KerberosToken();
        return (AccumuloClient)Accumulo.newClient().from(props).as((CharSequence)principal, (AuthenticationToken)token).build();
    }
}

