/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.ServerContext;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.net.SocketAppender;

public class AccumuloMonitorAppender
extends AsyncAppender
implements AutoCloseable {
    final ScheduledExecutorService executorService;
    final AtomicBoolean trackerScheduled = new AtomicBoolean(false);
    private int frequency = 0;
    private MonitorTracker tracker = null;

    public AccumuloMonitorAppender() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread t = new Thread(runnable, AccumuloMonitorAppender.class.getSimpleName() + " Location Tracker");
            t.setDaemon(true);
            return t;
        });
    }

    public void setFrequency(int millis) {
        if (millis > 0) {
            this.frequency = millis;
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    void setTracker(MonitorTracker monitorTracker) {
        this.tracker = monitorTracker;
    }

    public void activateOptions() {
        if (this.trackerScheduled.compareAndSet(false, true)) {
            if (this.frequency <= 0) {
                this.frequency = 5000;
            }
            if (this.tracker == null) {
                this.tracker = new MonitorTracker(this, new ZooCacheLocationSupplier(), new SocketAppenderFactory());
            }
            this.executorService.scheduleWithFixedDelay(this.tracker, this.frequency, this.frequency, TimeUnit.MILLISECONDS);
        }
        super.activateOptions();
    }

    @Override
    public void close() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
        super.close();
    }

    static class MonitorTracker
    implements Runnable {
        private final AccumuloMonitorAppender parentAsyncAppender;
        private final Supplier<MonitorLocation> currentLocationSupplier;
        private final Function<MonitorLocation, AppenderSkeleton> appenderFactory;
        private MonitorLocation lastLocation;
        private AppenderSkeleton lastSocketAppender;

        public MonitorTracker(AccumuloMonitorAppender appender, Supplier<MonitorLocation> currentLocationSupplier, Function<MonitorLocation, AppenderSkeleton> appenderFactory) {
            this.parentAsyncAppender = Objects.requireNonNull(appender);
            this.appenderFactory = Objects.requireNonNull(appenderFactory);
            this.currentLocationSupplier = Objects.requireNonNull(currentLocationSupplier);
            this.lastLocation = new MonitorLocation(0L, null);
            this.lastSocketAppender = null;
        }

        @Override
        public void run() {
            try {
                MonitorLocation currentLocation = this.currentLocationSupplier.get();
                if (!currentLocation.equals(this.lastLocation)) {
                    if (this.lastSocketAppender != null) {
                        this.parentAsyncAppender.removeAppender((Appender)this.lastSocketAppender);
                        this.lastSocketAppender.close();
                        this.lastSocketAppender = null;
                    }
                    if (currentLocation.hasLocation()) {
                        this.lastSocketAppender = this.appenderFactory.apply(currentLocation);
                        this.lastSocketAppender.activateOptions();
                        this.parentAsyncAppender.addAppender((Appender)this.lastSocketAppender);
                    }
                    this.lastLocation = currentLocation;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class SocketAppenderFactory
    implements Function<MonitorLocation, AppenderSkeleton> {
        private SocketAppenderFactory() {
        }

        @Override
        public AppenderSkeleton apply(MonitorLocation loc) {
            int defaultPort = Integer.parseUnsignedInt(Property.MONITOR_LOG4J_PORT.getDefaultValue());
            HostAndPort remote = HostAndPort.fromString((String)loc.getLocation());
            SocketAppender socketAppender = new SocketAppender();
            socketAppender.setApplication(System.getProperty("accumulo.application", "unknown"));
            socketAppender.setRemoteHost(remote.getHost());
            socketAppender.setPort(remote.getPortOrDefault(defaultPort));
            return socketAppender;
        }
    }

    private static class ZooCacheLocationSupplier
    implements Supplier<MonitorLocation> {
        private ServerContext context = null;
        private String path = null;
        private ZooCache zooCache = null;

        private ZooCacheLocationSupplier() {
        }

        @Override
        public MonitorLocation get() {
            if (this.context == null) {
                this.context = new ServerContext(new SiteConfiguration());
                this.path = this.context.getZooKeeperRoot() + "/monitor/log4j_addr";
                this.zooCache = this.context.getZooCache();
            }
            ZooCache.ZcStat stat = new ZooCache.ZcStat();
            byte[] loc = this.zooCache.get(this.path, stat);
            return new MonitorLocation(stat.getMzxid(), loc);
        }
    }

    static class MonitorLocation {
        private final String location;
        private final long modId;

        public MonitorLocation(long modId, byte[] location) {
            this.modId = modId;
            this.location = location == null ? null : new String(location, StandardCharsets.UTF_8);
        }

        public boolean hasLocation() {
            return this.location != null;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof MonitorLocation) {
                MonitorLocation other = (MonitorLocation)obj;
                return this.modId == other.modId && Objects.equals(this.location, other.location);
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.modId);
        }
    }
}

