/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.server.fs.PreferredVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceAwareVolumeChooser
extends PreferredVolumeChooser {
    public static final String RECOMPUTE_INTERVAL = "spaceaware.volume.chooser.recompute.interval";
    private long defaultComputationCacheDuration = 300000L;
    private LoadingCache<List<String>, WeightedRandomCollection> choiceCache = null;
    private static final Logger log = LoggerFactory.getLogger(SpaceAwareVolumeChooser.class);

    @Override
    public String choose(VolumeChooserEnvironment env, String[] options) throws VolumeChooser.VolumeChooserException {
        options = this.getPreferredVolumes(env, options);
        try {
            return ((WeightedRandomCollection)this.getCache(env).get(Arrays.asList(options))).next();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Execution exception when attempting to cache choice", e);
        }
    }

    private synchronized LoadingCache<List<String>, WeightedRandomCollection> getCache(final VolumeChooserEnvironment env) {
        if (this.choiceCache == null) {
            String propertyValue = env.getServiceEnv().getConfiguration().getCustom(RECOMPUTE_INTERVAL);
            long computationCacheDuration = StringUtils.isNotBlank((CharSequence)propertyValue) ? Long.parseLong(propertyValue) : this.defaultComputationCacheDuration;
            this.choiceCache = CacheBuilder.newBuilder().expireAfterWrite(computationCacheDuration, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<List<String>, WeightedRandomCollection>(){

                public WeightedRandomCollection load(List<String> key) {
                    return new WeightedRandomCollection(key, env, SpaceAwareVolumeChooser.this.random);
                }
            });
        }
        return this.choiceCache;
    }

    private static class WeightedRandomCollection {
        private final NavigableMap<Double, String> map = new TreeMap<Double, String>();
        private final Random random;
        private double total = 0.0;

        public WeightedRandomCollection(List<String> options, VolumeChooserEnvironment env, Random random) {
            this.random = random;
            if (options.size() < 1) {
                throw new IllegalStateException("Options was empty! No valid volumes to choose from.");
            }
            for (String option : options) {
                FileSystem pathFs = env.getFileSystem(option);
                try {
                    FsStatus optionStatus = pathFs.getStatus();
                    double percentFree = (double)optionStatus.getRemaining() / (double)optionStatus.getCapacity();
                    this.add(percentFree, option);
                }
                catch (IOException e) {
                    log.error("Unable to get file system status for" + option, (Throwable)e);
                }
            }
            if (this.map.size() < 1) {
                throw new IllegalStateException("Weighted options was empty! Could indicate an issue getting file system status or no free space on any volume");
            }
        }

        public WeightedRandomCollection add(double weight, String result) {
            if (weight <= 0.0) {
                log.info("Weight was 0. Not adding " + result);
                return this;
            }
            this.total += weight;
            this.map.put(this.total, result);
            return this;
        }

        public String next() {
            double value = this.random.nextDouble() * this.total;
            return this.map.higherEntry(value).getValue();
        }
    }
}

