/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import org.apache.bval.DynamicMetaBean;
import org.apache.bval.jsr.JsrMetaBeanFactory;
import org.apache.bval.jsr.UnknownPropertyException;
import org.apache.bval.jsr.util.PathNavigation;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.IndexedAccess;
import org.apache.bval.util.KeyedAccess;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.PropertyAccess;
import org.apache.bval.util.reflection.TypeUtils;

public class ValidationContextTraversal
extends PathNavigation.CallbackProcedure {
    private final ValidationContext<?> validationContext;
    private Type type;
    private Class<?> rawType;

    public ValidationContextTraversal(ValidationContext<?> validationContext) {
        this.validationContext = validationContext;
        this.init();
    }

    public void init() {
        this.rawType = this.validationContext.getMetaBean().getBeanClass();
        this.type = this.rawType;
    }

    @Override
    public void handleIndexOrKey(String token) {
        KeyedAccess access;
        this.moveDownIfNecessary();
        if (IndexedAccess.getJavaElementType((Type)this.type) != null) {
            try {
                Integer index = token == null ? null : Integer.valueOf(token);
                access = new IndexedAccess(this.type, index);
                this.validationContext.setCurrentIndex(index);
            }
            catch (NumberFormatException e) {
                throw new UnknownPropertyException(String.format("Cannot parse %s as an array/iterable index", token), e);
            }
        } else if (KeyedAccess.getJavaElementType((Type)this.type) != null) {
            access = new KeyedAccess(this.type, (Object)token);
            this.validationContext.setCurrentKey((Object)token);
        } else {
            throw new UnknownPropertyException(String.format("Cannot determine index/key type for %s", this.type));
        }
        Object value = this.validationContext.getBean();
        Class<?> child = value == null ? null : access.get(value);
        this.setType(child == null ? access.getJavaType() : child.getClass());
        this.validationContext.setBean(child, this.validationContext.getMetaBean().resolveMetaBean(child == null ? this.rawType : child));
    }

    @Override
    public void handleProperty(String token) {
        MetaProperty mp;
        this.moveDownIfNecessary();
        MetaBean metaBean = this.validationContext.getMetaBean();
        if (metaBean instanceof DynamicMetaBean) {
            metaBean = metaBean.resolveMetaBean(ObjectUtils.defaultIfNull((Object)this.validationContext.getBean(), this.rawType));
            this.validationContext.setMetaBean(metaBean);
        }
        if ((mp = metaBean.getProperty(token)) == null) {
            PropertyAccess access = PropertyAccess.getInstance(this.rawType, (String)token);
            if (access.isKnown()) {
                mp = JsrMetaBeanFactory.addMetaProperty(metaBean, (AccessStrategy)access);
            } else {
                throw new UnknownPropertyException("unknown property '" + token + "' in " + metaBean.getId());
            }
        }
        this.validationContext.setMetaProperty(mp);
        this.setType(mp.getType());
    }

    public void moveDownIfNecessary() {
        MetaProperty mp = this.validationContext.getMetaProperty();
        if (mp != null) {
            if (mp.getMetaBean() == null) {
                throw new UnknownPropertyException(String.format("Property %s.%s is not cascaded", mp.getParentMetaBean().getId(), mp.getName()));
            }
            this.validationContext.moveDown(mp, (AccessStrategy)new NullSafePropertyAccess(this.validationContext.getMetaBean().getBeanClass(), mp.getName()));
        }
    }

    protected void setType(Type type) {
        this.rawType = TypeUtils.getRawType((Type)type, (Type)this.type);
        this.type = type;
    }

    @Override
    public void handleGenericInIterable() {
        throw new UnsupportedOperationException("Cannot navigate a ValidationContext to []");
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    protected void complete() {
        super.complete();
        if (this.validationContext.getMetaProperty() != null) {
            return;
        }
        if (this.validationContext.getMetaBean() instanceof DynamicMetaBean) {
            this.validationContext.setMetaBean(this.validationContext.getMetaBean().resolveMetaBean(ObjectUtils.defaultIfNull((Object)this.validationContext.getBean(), this.rawType)));
        }
    }

    private static class NullSafePropertyAccess
    extends AccessStrategy {
        private final PropertyAccess wrapped;

        public NullSafePropertyAccess(Class<?> clazz, String propertyName) {
            this.wrapped = PropertyAccess.getInstance(clazz, (String)propertyName);
        }

        public Object get(Object bean) {
            return bean == null ? null : this.wrapped.get(bean);
        }

        public ElementType getElementType() {
            return this.wrapped.getElementType();
        }

        public Type getJavaType() {
            return this.wrapped.getJavaType();
        }

        public String getPropertyName() {
            return this.wrapped.getPropertyName();
        }
    }
}

