/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.ExchangeProperties;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.PropertyInject;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHelper;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MethodsFilter;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.AnnotationExpressionFactory;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInfo.class);
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private final CamelContext camelContext;
    private final BeanComponent component;
    private final Class<?> type;
    private final ParameterMappingStrategy strategy;
    private final MethodInfo defaultMethod;
    private Map<String, List<MethodInfo>> operations = new HashMap<String, List<MethodInfo>>();
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithNoBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithCustomAnnotation = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithHandlerAnnotation = new ArrayList<MethodInfo>();
    private Map<Method, MethodInfo> methodMap = new HashMap<Method, MethodInfo>();
    private boolean publicConstructors;
    private boolean publicNoArgConstructors;

    public BeanInfo(CamelContext camelContext, Class<?> type) {
        this(camelContext, type, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Method explicitMethod) {
        this(camelContext, explicitMethod.getDeclaringClass(), explicitMethod, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Class<?> type, ParameterMappingStrategy strategy) {
        this(camelContext, type, null, strategy);
    }

    public BeanInfo(CamelContext camelContext, Class<?> type, Method explicitMethod, ParameterMappingStrategy strategy) {
        List<MethodInfo> methods;
        this.camelContext = camelContext;
        this.type = type;
        this.strategy = strategy;
        this.component = (BeanComponent)camelContext.getComponent("bean", BeanComponent.class);
        BeanInfoCacheKey key = new BeanInfoCacheKey(type, explicitMethod);
        BeanInfo beanInfo = this.component.getBeanInfoFromCache(key);
        if (beanInfo != null) {
            this.defaultMethod = beanInfo.defaultMethod;
            this.operations = beanInfo.operations;
            this.operationsWithBody = beanInfo.operationsWithBody;
            this.operationsWithNoBody = beanInfo.operationsWithNoBody;
            this.operationsWithCustomAnnotation = beanInfo.operationsWithCustomAnnotation;
            this.operationsWithHandlerAnnotation = beanInfo.operationsWithHandlerAnnotation;
            this.methodMap = beanInfo.methodMap;
            this.publicConstructors = beanInfo.publicConstructors;
            this.publicNoArgConstructors = beanInfo.publicNoArgConstructors;
            return;
        }
        if (explicitMethod != null) {
            if (!this.isValidMethod(type, explicitMethod)) {
                throw new IllegalArgumentException("The method " + explicitMethod + " is not valid (for example the method must be public)");
            }
            this.introspect(this.getType(), explicitMethod);
        } else {
            this.introspect(this.getType());
        }
        MethodInfo method = null;
        if (this.operations.size() == 1 && (methods = this.operations.values().iterator().next()).size() == 1) {
            method = methods.get(0);
        }
        this.defaultMethod = method;
        this.operations = Collections.unmodifiableMap(this.operations);
        this.operationsWithBody = Collections.unmodifiableList(this.operationsWithBody);
        this.operationsWithNoBody = Collections.unmodifiableList(this.operationsWithNoBody);
        this.operationsWithCustomAnnotation = Collections.unmodifiableList(this.operationsWithCustomAnnotation);
        this.operationsWithHandlerAnnotation = Collections.unmodifiableList(this.operationsWithHandlerAnnotation);
        this.methodMap = Collections.unmodifiableMap(this.methodMap);
        this.component.addBeanInfoToCache(key, this);
    }

    public Class<?> getType() {
        return this.type;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        Registry registry = camelContext.getRegistry();
        ParameterMappingStrategy answer = (ParameterMappingStrategy)registry.lookupByNameAndType("CamelBeanParameterMappingStrategy", ParameterMappingStrategy.class);
        if (answer == null) {
            answer = new DefaultParameterMappingStrategy();
        }
        return answer;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws AmbiguousMethodCallException, MethodNotFoundException {
        return this.createInvocation(pojo, exchange, null);
    }

    private MethodInvocation createInvocation(Object pojo, Exchange exchange, Method explicitMethod) throws AmbiguousMethodCallException, MethodNotFoundException {
        MethodInfo methodInfo = null;
        if (explicitMethod != null) {
            for (List<MethodInfo> infos : this.operations.values()) {
                for (MethodInfo info : infos) {
                    if (!explicitMethod.equals(info.getMethod())) continue;
                    return info.createMethodInvocation(pojo, info.hasParameters(), exchange);
                }
            }
            throw new MethodNotFoundException(exchange, pojo, explicitMethod.getName());
        }
        String methodName = (String)exchange.getIn().getHeader("CamelBeanMethodName", String.class);
        if (methodName != null) {
            String name = methodName;
            if (methodName.contains("(")) {
                name = StringHelper.before((String)methodName, (String)"(");
                if (!methodName.endsWith(")")) {
                    throw new IllegalArgumentException("Method should end with parenthesis, was " + methodName);
                }
                if (StringHelper.betweenOuterPair((String)methodName, (char)'(', (char)')') == null) {
                    throw new IllegalArgumentException("Method should have even pair of parenthesis, was " + methodName);
                }
            }
            boolean emptyParameters = methodName.endsWith("()");
            if ("class".equals(name) || "getClass".equals(name)) {
                try {
                    Method method = pojo.getClass().getMethod("getClass", new Class[0]);
                    methodInfo = new MethodInfo(exchange.getContext(), pojo.getClass(), method, Collections.emptyList(), Collections.emptyList(), false, false);
                }
                catch (NoSuchMethodException e) {
                    throw new MethodNotFoundException(exchange, pojo, "getClass");
                }
            } else if ("length".equals(name) && pojo.getClass().isArray()) {
                try {
                    Method method = org.apache.camel.util.ObjectHelper.class.getMethod("arrayLength", Object[].class);
                    ParameterInfo pi = new ParameterInfo(0, Object[].class, null, ExpressionBuilder.mandatoryBodyExpression(Object[].class, (boolean)true));
                    ArrayList<ParameterInfo> lpi = new ArrayList<ParameterInfo>(1);
                    lpi.add(pi);
                    methodInfo = new MethodInfo(exchange.getContext(), pojo.getClass(), method, lpi, lpi, false, false);
                    exchange.getIn().setBody(pojo);
                }
                catch (NoSuchMethodException e) {
                    throw new MethodNotFoundException(exchange, pojo, "getClass");
                }
            } else {
                List<MethodInfo> methods = this.getOperations(name);
                if (methods != null && methods.size() == 1) {
                    methodInfo = methods.get(0);
                    if (emptyParameters && methodInfo.hasParameters()) {
                        throw new MethodNotFoundException(exchange, pojo, methodName, "(with no parameters)");
                    }
                } else if (methods != null) {
                    methodInfo = this.chooseMethod(pojo, exchange, methodName);
                    if (emptyParameters && (methodInfo == null || methodInfo.hasParameters())) {
                        throw new MethodNotFoundException(exchange, pojo, methodName, "(with no parameters)");
                    }
                    if (methodInfo == null || name != null && !name.equals(methodInfo.getMethod().getName())) {
                        throw new AmbiguousMethodCallException(exchange, methods);
                    }
                } else {
                    throw new MethodNotFoundException(exchange, pojo, methodName);
                }
            }
        }
        if (methodInfo == null && this.methodMap.size() >= 2) {
            methodInfo = this.chooseMethod(pojo, exchange, null);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            LOG.trace("Chosen method to invoke: {} on bean: {}", (Object)methodInfo, pojo);
            return methodInfo.createMethodInvocation(pojo, methodInfo.hasParameters(), exchange);
        }
        LOG.debug("Cannot find suitable method to invoke on bean: {}", pojo);
        return null;
    }

    private void introspect(Class<?> clazz) {
        this.publicConstructors = clazz.getConstructors().length > 0;
        this.publicNoArgConstructors = org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(clazz);
        MethodsFilter methods = new MethodsFilter(this.getType());
        this.introspect(clazz, methods);
        for (Method method : methods.asReadOnlyList()) {
            boolean valid = this.isValidMethod(clazz, method);
            LOG.trace("Method: {} is valid: {}", (Object)method, (Object)valid);
            if (!valid) continue;
            this.introspect(clazz, method);
        }
    }

    private void introspect(Class<?> clazz, MethodsFilter filteredMethods) {
        clazz = BeanInfo.getTargetClass(clazz);
        org.apache.camel.util.ObjectHelper.notNull(clazz, (String)"clazz", (Object)this);
        LOG.trace("Introspecting class: {}", clazz);
        for (Method m : Arrays.asList(clazz.getDeclaredMethods())) {
            filteredMethods.filterMethod(m);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.introspect(superClass, filteredMethods);
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            this.introspect(superInterface, filteredMethods);
        }
    }

    private MethodInfo introspect(Class<?> clazz, Method method) {
        LOG.trace("Introspecting class: {}, method: {}", clazz, (Object)method);
        String opName = method.getName();
        MethodInfo methodInfo = this.createMethodInfo(clazz, method);
        MethodInfo existingMethodInfo = this.findMostSpecificOverride(methodInfo);
        if (existingMethodInfo != null) {
            LOG.trace("This method is already overridden in a subclass, so the method from the sub class is preferred: {}", (Object)existingMethodInfo);
            return existingMethodInfo;
        }
        LOG.trace("Adding operation: {} for method: {}", (Object)opName, (Object)methodInfo);
        List<MethodInfo> existing = this.getOperations(opName);
        if (existing != null) {
            existing.add(methodInfo);
        } else {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            methods.add(methodInfo);
            this.operations.put(opName, methods);
        }
        if (methodInfo.hasCustomAnnotation()) {
            this.operationsWithCustomAnnotation.add(methodInfo);
        } else if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        } else {
            this.operationsWithNoBody.add(methodInfo);
        }
        if (methodInfo.hasHandlerAnnotation()) {
            this.operationsWithHandlerAnnotation.add(methodInfo);
        }
        this.methodMap.put(method, methodInfo);
        return methodInfo;
    }

    public MethodInfo getMethodInfo(Method method) {
        Class<?> superclass;
        MethodInfo answer = this.methodMap.get(method);
        if (answer == null) {
            for (Map.Entry<Method, MethodInfo> methodEntry : this.methodMap.entrySet()) {
                Method source = methodEntry.getKey();
                if (!org.apache.camel.util.ObjectHelper.isOverridingMethod(this.getType(), (Method)source, (Method)method, (boolean)false)) continue;
                answer = methodEntry.getValue();
                break;
            }
        }
        if (answer == null && this.type != Object.class && (superclass = this.type.getSuperclass()) != null && superclass != Object.class) {
            BeanInfo superBeanInfo = new BeanInfo(this.camelContext, superclass, this.strategy);
            return superBeanInfo.getMethodInfo(method);
        }
        return answer;
    }

    protected MethodInfo createMethodInfo(Class<?> clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Annotation>[] parametersAnnotations = this.collectParameterAnnotations(clazz, method);
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        boolean hasCustomAnnotation = false;
        boolean hasHandlerAnnotation = org.apache.camel.util.ObjectHelper.hasAnnotation((Annotation[])method.getAnnotations(), Handler.class);
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", new Object[]{clazz, method, size});
        }
        for (int i = 0; i < size; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i].toArray(new Annotation[parametersAnnotations[i].size()]);
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            hasCustomAnnotation |= expression != null;
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            LOG.trace("Parameter #{}: {}", (Object)i, (Object)parameterInfo);
            parameters.add(parameterInfo);
            if (expression == null) {
                boolean bodyAnnotation = org.apache.camel.util.ObjectHelper.hasAnnotation((Annotation[])parameterAnnotations, Body.class);
                LOG.trace("Parameter #{} has @Body annotation", (Object)i);
                hasCustomAnnotation |= bodyAnnotation;
                if (bodyParameters.isEmpty()) {
                    expression = Exchange.class.isAssignableFrom(parameterType) ? ExpressionBuilder.exchangeExpression() : ExpressionBuilder.mandatoryBodyExpression(parameterType, (boolean)true);
                    LOG.trace("Parameter #{} is the body parameter using expression {}", (Object)i, (Object)expression);
                    parameterInfo.setExpression(expression);
                    bodyParameters.add(parameterInfo);
                }
            }
            LOG.trace("Parameter #{} has parameter info: {}", (Object)i, (Object)parameterInfo);
        }
        return new MethodInfo(this.camelContext, clazz, method, parameters, bodyParameters, hasCustomAnnotation, hasHandlerAnnotation);
    }

    protected List<Annotation>[] collectParameterAnnotations(Class<?> c, Method m) {
        List[] annotations = new List[m.getParameterCount()];
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = new ArrayList();
        }
        this.collectParameterAnnotations(c, m, annotations);
        return annotations;
    }

    protected void collectParameterAnnotations(Class<?> c, Method m, List<Annotation>[] a) {
        if (c.getName().startsWith("java")) {
            return;
        }
        try {
            Annotation[][] pa = c.getDeclaredMethod(m.getName(), m.getParameterTypes()).getParameterAnnotations();
            for (int i = 0; i < pa.length; ++i) {
                a[i].addAll(Arrays.asList(pa[i]));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<?> i : c.getInterfaces()) {
            this.collectParameterAnnotations(i, m, a);
        }
        if (!c.isInterface() && c.getSuperclass() != null && c.getSuperclass() != Object.class) {
            this.collectParameterAnnotations(c.getSuperclass(), m, a);
        }
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange, String name) throws AmbiguousMethodCallException {
        boolean noParameters;
        ArrayList<MethodInfo> localOperationsWithBody = null;
        if (!this.operationsWithBody.isEmpty()) {
            localOperationsWithBody = new ArrayList<MethodInfo>(this.operationsWithBody);
        }
        ArrayList<MethodInfo> localOperationsWithNoBody = null;
        if (!this.operationsWithNoBody.isEmpty()) {
            localOperationsWithNoBody = new ArrayList<MethodInfo>(this.operationsWithNoBody);
        }
        ArrayList<MethodInfo> localOperationsWithCustomAnnotation = null;
        if (!this.operationsWithCustomAnnotation.isEmpty()) {
            localOperationsWithCustomAnnotation = new ArrayList<MethodInfo>(this.operationsWithCustomAnnotation);
        }
        ArrayList<MethodInfo> localOperationsWithHandlerAnnotation = null;
        if (!this.operationsWithHandlerAnnotation.isEmpty()) {
            localOperationsWithHandlerAnnotation = new ArrayList<MethodInfo>(this.operationsWithHandlerAnnotation);
        }
        if (localOperationsWithBody != null) {
            this.removeAllAbstractMethods(localOperationsWithBody);
        }
        if (localOperationsWithNoBody != null) {
            this.removeAllAbstractMethods(localOperationsWithNoBody);
        }
        if (localOperationsWithCustomAnnotation != null) {
            this.removeAllAbstractMethods(localOperationsWithCustomAnnotation);
        }
        if (localOperationsWithHandlerAnnotation != null) {
            this.removeAllAbstractMethods(localOperationsWithHandlerAnnotation);
        }
        if (name != null) {
            if (localOperationsWithHandlerAnnotation != null) {
                this.removeNonMatchingMethods(localOperationsWithHandlerAnnotation, name);
            }
            if (localOperationsWithCustomAnnotation != null) {
                this.removeNonMatchingMethods(localOperationsWithCustomAnnotation, name);
            }
            if (localOperationsWithBody != null) {
                this.removeNonMatchingMethods(localOperationsWithBody, name);
            }
            if (localOperationsWithNoBody != null) {
                this.removeNonMatchingMethods(localOperationsWithNoBody, name);
            }
        } else {
            if (localOperationsWithHandlerAnnotation != null) {
                BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithHandlerAnnotation);
            }
            if (localOperationsWithCustomAnnotation != null) {
                BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithCustomAnnotation);
            }
            if (localOperationsWithBody != null) {
                BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithBody);
            }
            if (localOperationsWithNoBody != null) {
                BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithNoBody);
            }
        }
        if (localOperationsWithHandlerAnnotation != null && localOperationsWithHandlerAnnotation.size() > 1) {
            throw new AmbiguousMethodCallException(exchange, localOperationsWithHandlerAnnotation);
        }
        if (localOperationsWithHandlerAnnotation != null && localOperationsWithHandlerAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithHandlerAnnotation.get(0);
        }
        if (localOperationsWithCustomAnnotation != null && localOperationsWithCustomAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithCustomAnnotation.get(0);
        }
        boolean bl = noParameters = name != null && name.endsWith("()");
        if (noParameters && localOperationsWithNoBody != null && localOperationsWithNoBody.size() == 1) {
            return (MethodInfo)localOperationsWithNoBody.get(0);
        }
        if (!noParameters && localOperationsWithBody != null && localOperationsWithBody.size() == 1 && localOperationsWithCustomAnnotation == null) {
            return (MethodInfo)localOperationsWithBody.get(0);
        }
        if (localOperationsWithBody != null || localOperationsWithCustomAnnotation != null) {
            ArrayList<MethodInfo> possibleOperations = new ArrayList<MethodInfo>();
            if (localOperationsWithBody != null) {
                possibleOperations.addAll(localOperationsWithBody);
            }
            if (localOperationsWithCustomAnnotation != null) {
                possibleOperations.addAll(localOperationsWithCustomAnnotation);
            }
            if (!possibleOperations.isEmpty()) {
                String parameters;
                MethodInfo answer = null;
                if (name != null && (parameters = StringHelper.between((String)name, (String)"(", (String)")")) != null) {
                    LOG.trace("Choosing best matching method matching parameters: {}", (Object)parameters);
                    answer = this.chooseMethodWithMatchingParameters(exchange, parameters, possibleOperations);
                }
                if (answer == null) {
                    answer = this.chooseMethodWithMatchingBody(exchange, possibleOperations, localOperationsWithCustomAnnotation);
                }
                if (answer == null && possibleOperations.size() > 1) {
                    answer = this.getSingleCovariantMethod(possibleOperations);
                }
                if (answer == null) {
                    throw new AmbiguousMethodCallException(exchange, possibleOperations);
                }
                return answer;
            }
        }
        return null;
    }

    private MethodInfo chooseMethodWithMatchingParameters(Exchange exchange, String parameters, Collection<MethodInfo> operationList) throws AmbiguousMethodCallException {
        MethodInfo answer;
        int count = 0;
        for (Object o : ObjectHelper.createIterable((String)parameters)) {
            ++count;
        }
        ArrayList<MethodInfo> operations = new ArrayList<MethodInfo>();
        for (MethodInfo info : operationList) {
            if (info.getParameters().size() != count) continue;
            operations.add(info);
        }
        if (operations.isEmpty()) {
            return null;
        }
        if (operations.size() == 1) {
            return (MethodInfo)operations.get(0);
        }
        ArrayList<MethodInfo> candidates = new ArrayList<MethodInfo>();
        MethodInfo fallbackCandidate = null;
        for (MethodInfo info : operations) {
            Iterator it = ObjectHelper.createIterator((Object)parameters, (String)",", (boolean)false);
            int index = 0;
            boolean matches = true;
            while (it.hasNext()) {
                String parameter = (String)it.next();
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = BeanHelper.getValidParameterType(parameter);
                Class<?> expectedType = info.getParameters().get(index).getType();
                if (parameterType != null && expectedType != null) {
                    if (StringHelper.hasStartToken((String)parameter, (String)"simple")) {
                        LOG.trace("Evaluating simple expression for parameter #{}: {} to determine the class type of the parameter", (Object)index, (Object)parameter);
                        Object out = this.getCamelContext().resolveLanguage("simple").createExpression(parameter).evaluate(exchange, Object.class);
                        if (out != null) {
                            parameterType = out.getClass();
                        }
                    }
                    if (Object.class.equals(expectedType)) {
                        fallbackCandidate = info;
                        matches = false;
                        break;
                    }
                    boolean matchingTypes = this.isParameterMatchingType(parameterType, expectedType);
                    if (!matchingTypes) {
                        matches = false;
                        break;
                    }
                }
                ++index;
            }
            if (!matches) continue;
            candidates.add(info);
        }
        if (candidates.size() > 1 && (answer = this.getSingleCovariantMethod(candidates)) != null) {
            return answer;
        }
        return candidates.size() == 1 ? (MethodInfo)candidates.get(0) : fallbackCandidate;
    }

    private boolean isParameterMatchingType(Class<?> parameterType, Class<?> expectedType) {
        if (Number.class.equals(parameterType) && (Integer.class.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType) || Integer.TYPE.isAssignableFrom(expectedType) || Long.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        if (Boolean.class.equals(parameterType) && (Boolean.class.isAssignableFrom(expectedType) || Boolean.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        return parameterType.isAssignableFrom(expectedType);
    }

    private MethodInfo getSingleCovariantMethod(Collection<MethodInfo> candidates) {
        MethodInfo firstCandidate = candidates.iterator().next();
        for (MethodInfo candidate : candidates) {
            if (firstCandidate.isCovariantWith(candidate)) continue;
            return null;
        }
        return firstCandidate;
    }

    private MethodInfo chooseMethodWithMatchingBody(Exchange exchange, Collection<MethodInfo> operationList, List<MethodInfo> operationsWithCustomAnnotation) throws AmbiguousMethodCallException {
        Message in = exchange.getIn();
        Object body = in.getBody();
        if (body != null) {
            Class<?> bodyType = body.getClass();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matching for method with a single parameter that matches type: {}", (Object)bodyType.getCanonicalName());
            }
            ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
            ArrayList<MethodInfo> possiblesWithException = null;
            for (MethodInfo methodInfo : operationList) {
                boolean out = exchange.getPattern().isOutCapable();
                if (out && methodInfo.isReturnTypeVoid() || !methodInfo.bodyParameterMatches(bodyType)) continue;
                LOG.trace("Found a possible method: {}", (Object)methodInfo);
                if (methodInfo.hasExceptionParameter()) {
                    if (possiblesWithException == null) {
                        possiblesWithException = new ArrayList<MethodInfo>();
                    }
                    possiblesWithException.add(methodInfo);
                    continue;
                }
                possibles.add(methodInfo);
            }
            return this.chooseBestPossibleMethodInfo(exchange, operationList, body, possibles, possiblesWithException, operationsWithCustomAnnotation);
        }
        return null;
    }

    private MethodInfo chooseBestPossibleMethodInfo(Exchange exchange, Collection<MethodInfo> operationList, Object body, List<MethodInfo> possibles, List<MethodInfo> possiblesWithException, List<MethodInfo> possibleWithCustomAnnotation) throws AmbiguousMethodCallException {
        Exception exception = (Exception)ExpressionBuilder.exchangeExceptionExpression().evaluate(exchange, Exception.class);
        if (exception != null && possiblesWithException != null && possiblesWithException.size() == 1) {
            LOG.trace("Exchange has exception set so we prefer method that also has exception as parameter");
            return possiblesWithException.get(0);
        }
        if (possibles.size() == 1) {
            return possibles.get(0);
        }
        if (possibles.isEmpty()) {
            LOG.trace("No possible methods so now trying to convert body to parameter types");
            Object newBody = null;
            MethodInfo matched = null;
            int matchCounter = 0;
            for (MethodInfo methodInfo : operationList) {
                if (methodInfo.getBodyParameterType() == null) continue;
                if (methodInfo.getBodyParameterType().isInstance(body)) {
                    return methodInfo;
                }
                Object value = exchange.getContext().getTypeConverter().tryConvertTo(methodInfo.getBodyParameterType(), exchange, body);
                if (value == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Converted body from: {} to: {}", (Object)body.getClass().getCanonicalName(), (Object)methodInfo.getBodyParameterType().getCanonicalName());
                }
                ++matchCounter;
                newBody = value;
                matched = methodInfo;
            }
            if (matchCounter > 1) {
                throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, matched));
            }
            if (matched != null) {
                LOG.trace("Setting converted body: {}", body);
                Message in = exchange.getIn();
                in.setBody(newBody);
                return matched;
            }
        } else {
            if (possibleWithCustomAnnotation != null && possibleWithCustomAnnotation.size() == 1) {
                MethodInfo answer = possibleWithCustomAnnotation.get(0);
                LOG.trace("There are only one method with annotations so we choose it: {}", (Object)answer);
                return answer;
            }
            MethodInfo chosen = this.chooseMethodWithCustomAnnotations(possibles);
            if (chosen != null) {
                return chosen;
            }
            chosen = this.getSingleCovariantMethod(possibles);
            if (chosen != null) {
                return chosen;
            }
            throw new AmbiguousMethodCallException(exchange, possibles);
        }
        return null;
    }

    protected boolean isValidMethod(Class<?> clazz, Method method) {
        for (Method excluded : EXCLUDED_METHODS) {
            if (!org.apache.camel.util.ObjectHelper.isOverridingMethod((Method)excluded, (Method)method)) continue;
            return false;
        }
        boolean privateMethod = Modifier.isPrivate(method.getModifiers());
        if (privateMethod) {
            return false;
        }
        return (method.getReturnType() == null || !Exchange.class.isAssignableFrom(method.getReturnType())) && !method.isBridge();
    }

    private MethodInfo findMostSpecificOverride(MethodInfo proposedMethodInfo) {
        for (MethodInfo alreadyRegisteredMethodInfo : this.methodMap.values()) {
            Method alreadyRegisteredMethod = alreadyRegisteredMethodInfo.getMethod();
            Method proposedMethod = proposedMethodInfo.getMethod();
            if (org.apache.camel.util.ObjectHelper.isOverridingMethod(this.getType(), (Method)proposedMethod, (Method)alreadyRegisteredMethod, (boolean)false)) {
                return alreadyRegisteredMethodInfo;
            }
            if (!org.apache.camel.util.ObjectHelper.isOverridingMethod(this.getType(), (Method)alreadyRegisteredMethod, (Method)proposedMethod, (boolean)false)) continue;
            return proposedMethodInfo;
        }
        return null;
    }

    private MethodInfo chooseMethodWithCustomAnnotations(Collection<MethodInfo> possibles) {
        MethodInfo chosen = null;
        for (MethodInfo possible : possibles) {
            if (!possible.hasCustomAnnotation()) continue;
            if (chosen != null) {
                chosen = null;
                break;
            }
            chosen = possible;
        }
        return chosen;
    }

    private Expression createParameterUnmarshalExpression(Class<?> clazz, Method method, Class<?> parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    private Expression createParameterUnmarshalExpressionForAnnotation(Class<?> clazz, Method method, Class<?> parameterType, Annotation annotation) {
        if (annotation instanceof ExchangeProperty) {
            ExchangeProperty propertyAnnotation = (ExchangeProperty)annotation;
            return ExpressionBuilder.exchangePropertyExpression((String)propertyAnnotation.value());
        }
        if (annotation instanceof ExchangeProperties) {
            return ExpressionBuilder.exchangePropertiesExpression();
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression((String)headerAnnotation.value());
        }
        if (annotation instanceof Headers) {
            return ExpressionBuilder.headersExpression();
        }
        if (annotation instanceof ExchangeException) {
            return ExpressionBuilder.exchangeExceptionExpression((Class)CastUtils.cast(parameterType, Exception.class));
        }
        if (annotation instanceof PropertyInject) {
            PropertyInject propertyAnnotation = (PropertyInject)annotation;
            Expression inject = ExpressionBuilder.propertiesComponentExpression((String)propertyAnnotation.value(), (String)propertyAnnotation.defaultValue());
            return ExpressionBuilder.convertToExpression((Expression)inject, parameterType);
        }
        LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
        if (languageAnnotation != null) {
            Object object;
            Class<DefaultAnnotationExpressionFactory> type = languageAnnotation.factory();
            if (type == Object.class) {
                type = DefaultAnnotationExpressionFactory.class;
            }
            if ((object = this.camelContext.getInjector().newInstance(type)) instanceof AnnotationExpressionFactory) {
                AnnotationExpressionFactory expressionFactory = (AnnotationExpressionFactory)object;
                return expressionFactory.createExpression(this.camelContext, annotation, languageAnnotation, parameterType);
            }
            LOG.warn("Ignoring bad annotation: " + languageAnnotation + "on method: " + method + " which declares a factory: " + type.getName() + " which does not implement " + AnnotationExpressionFactory.class.getName());
        }
        return null;
    }

    private static void removeAllSetterOrGetterMethods(List<MethodInfo> methods) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (BeanInfo.isGetter(info.getMethod())) {
                it.remove();
                continue;
            }
            if (!BeanInfo.isSetter(info.getMethod())) continue;
            it.remove();
        }
    }

    private void removeNonMatchingMethods(List<MethodInfo> methods, String name) {
        methods.removeIf(info -> !this.matchMethod(info.getMethod(), name));
    }

    private void removeAllAbstractMethods(List<MethodInfo> methods) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            boolean isFromInterface = Modifier.isInterface(info.getMethod().getDeclaringClass().getModifiers());
            if (isFromInterface || !Modifier.isAbstract(info.getMethod().getModifiers())) continue;
            it.remove();
        }
    }

    private boolean matchMethod(Method method, String methodName) {
        if (methodName == null) {
            return true;
        }
        if (methodName.contains("(") && !methodName.endsWith(")")) {
            throw new IllegalArgumentException("Name must have both starting and ending parenthesis, was: " + methodName);
        }
        String name = methodName;
        if (name.contains("(")) {
            name = StringHelper.before((String)name, (String)"(");
        }
        if (name != null && !name.equals(method.getName())) {
            return false;
        }
        boolean noParameters = methodName.endsWith("()");
        if (noParameters) {
            return method.getParameterCount() == 0;
        }
        String types = StringHelper.between((String)methodName, (String)"(", (String)")");
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)types)) {
            String[] parameters = StringQuoteHelper.splitSafeQuote((String)types, (char)',');
            Class<?>[] parameterTypes = null;
            Iterator it = ObjectHelper.createIterator((Object)parameters);
            for (int i = 0; i < method.getParameterCount(); ++i) {
                if (it.hasNext()) {
                    Boolean assignable;
                    if (parameterTypes == null) {
                        parameterTypes = method.getParameterTypes();
                    }
                    Class<?> parameterType = parameterTypes[i];
                    String qualifyType = (String)it.next();
                    if (org.apache.camel.util.ObjectHelper.isEmpty((Object)qualifyType) || "*".equals(qualifyType = qualifyType.trim()) || BeanHelper.isValidParameterValue(qualifyType) || (assignable = BeanHelper.isAssignableToExpectedType(this.getCamelContext().getClassResolver(), qualifyType, parameterType)) == null || assignable.booleanValue()) continue;
                    return false;
                }
                return false;
            }
            if (it.hasNext()) {
                return false;
            }
        }
        return true;
    }

    private static Class<?> getTargetClass(Class<?> clazz) {
        Class<?> superClass;
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public boolean hasMethod(String methodName) {
        return this.getOperations(methodName) != null;
    }

    public boolean hasStaticMethod(String methodName) {
        List<MethodInfo> methods = this.getOperations(methodName);
        if (methods == null || methods.isEmpty()) {
            return false;
        }
        for (MethodInfo method : methods) {
            if (!method.isStaticMethod()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPublicConstructors() {
        return this.publicConstructors;
    }

    public boolean hasPublicNoArgConstructors() {
        return this.publicNoArgConstructors;
    }

    public List<MethodInfo> getMethods() {
        if (this.operations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Collection collection : this.operations.values()) {
            methods.addAll(collection);
        }
        if (methods.size() > 1) {
            methods.sort(Comparator.comparing(o -> o.getMethod().getName()));
        }
        return methods;
    }

    public boolean hasAnyMethodHandlerAnnotation() {
        return !this.operationsWithHandlerAnnotation.isEmpty();
    }

    private List<MethodInfo> getOperations(String methodName) {
        List<MethodInfo> answer;
        if (methodName.contains("(")) {
            methodName = StringHelper.before((String)methodName, (String)"(");
        }
        if ((answer = this.operations.get(methodName)) != null) {
            return answer;
        }
        for (Method method : this.methodMap.keySet()) {
            if (!BeanInfo.isGetter(method)) continue;
            String shorthandMethodName = BeanInfo.getGetterShorthandName(method);
            if (methodName == null || !methodName.equals(shorthandMethodName)) continue;
            return this.operations.get(method.getName());
        }
        return null;
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        if (name.startsWith("get") && name.length() >= 4 && Character.isUpperCase(name.charAt(3))) {
            return parameterCount == 0 && !type.equals(Void.TYPE);
        }
        if (name.startsWith("is") && name.length() >= 3 && Character.isUpperCase(name.charAt(2))) {
            return parameterCount == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return false;
    }

    public static boolean isSetter(Method method) {
        boolean validName;
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        boolean bl = validName = name.startsWith("set") && name.length() >= 4 && Character.isUpperCase(name.charAt(3));
        if (validName && parameterCount == 1) {
            return type.equals(Void.TYPE);
        }
        return false;
    }

    public static String getGetterShorthandName(Method method) {
        if (!BeanInfo.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getDeclaredMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getDeclaredMethods()));
        EXCLUDED_METHODS.removeIf(m -> Modifier.isPrivate(m.getModifiers()));
        try {
            EXCLUDED_METHODS.remove(Object.class.getDeclaredMethod("toString", new Class[0]));
            EXCLUDED_METHODS.remove(Proxy.class.getDeclaredMethod("toString", new Class[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

