/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.builder.ExpressionBuilder;

public class DefaultParameterMappingStrategy
implements ParameterMappingStrategy {
    private final Map<Class<?>, Expression> parameterTypeToExpressionMap = new ConcurrentHashMap();

    public DefaultParameterMappingStrategy() {
        this.loadDefaultRegistry();
    }

    @Override
    public Expression getDefaultParameterTypeExpression(Class<?> parameterType) {
        return this.parameterTypeToExpressionMap.get(parameterType);
    }

    public void addParameterMapping(Class<?> parameterType, Expression expression) {
        this.parameterTypeToExpressionMap.put(parameterType, expression);
    }

    public void loadDefaultRegistry() {
        this.addParameterMapping(Exchange.class, ExpressionBuilder.exchangeExpression());
        this.addParameterMapping(Message.class, ExpressionBuilder.inMessageExpression());
        this.addParameterMapping(Exception.class, ExpressionBuilder.exchangeExceptionExpression());
        this.addParameterMapping(TypeConverter.class, ExpressionBuilder.typeConverterExpression());
        this.addParameterMapping(Registry.class, ExpressionBuilder.registryExpression());
        this.addParameterMapping(CamelContext.class, ExpressionBuilder.camelContextExpression());
    }
}

