/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponent;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;

public interface InfinispanComponentBuilderFactory {
    public static InfinispanComponentBuilder infinispan() {
        return new InfinispanComponentBuilderImpl();
    }

    public static class InfinispanComponentBuilderImpl
    extends AbstractComponentBuilder<InfinispanRemoteComponent>
    implements InfinispanComponentBuilder {
        @Override
        protected InfinispanRemoteComponent buildConcreteComponent() {
            return new InfinispanRemoteComponent();
        }

        private InfinispanRemoteConfiguration getOrCreateConfiguration(InfinispanRemoteComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new InfinispanRemoteConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((InfinispanRemoteComponent)component).setConfiguration((InfinispanRemoteConfiguration)value);
                    return true;
                }
                case "hosts": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setHosts((String)value);
                    return true;
                }
                case "queryBuilder": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setQueryBuilder((InfinispanQueryBuilder)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((InfinispanRemoteComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "customListener": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setCustomListener((InfinispanRemoteCustomListener)value);
                    return true;
                }
                case "eventTypes": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setEventTypes((String)value);
                    return true;
                }
                case "defaultValue": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setDefaultValue(value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setKey(value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((InfinispanRemoteComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "oldValue": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setOldValue(value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setOperation((InfinispanOperation)value);
                    return true;
                }
                case "value": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setValue(value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((InfinispanRemoteComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "cacheContainer": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setCacheContainer((RemoteCacheManager)value);
                    return true;
                }
                case "cacheContainerConfiguration": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setCacheContainerConfiguration((Configuration)value);
                    return true;
                }
                case "configurationProperties": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setConfigurationProperties((Map)value);
                    return true;
                }
                case "configurationUri": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "flags": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setFlags((String)value);
                    return true;
                }
                case "remappingFunction": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setRemappingFunction((BiFunction)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setPassword((String)value);
                    return true;
                }
                case "saslMechanism": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setSaslMechanism((String)value);
                    return true;
                }
                case "secure": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setSecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "securityRealm": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setSecurityRealm((String)value);
                    return true;
                }
                case "securityServerName": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setSecurityServerName((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((InfinispanRemoteComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface InfinispanComponentBuilder
    extends ComponentBuilder<InfinispanRemoteComponent> {
        default public InfinispanComponentBuilder configuration(InfinispanRemoteConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public InfinispanComponentBuilder hosts(String hosts) {
            this.doSetProperty("hosts", hosts);
            return this;
        }

        default public InfinispanComponentBuilder queryBuilder(InfinispanQueryBuilder queryBuilder) {
            this.doSetProperty("queryBuilder", queryBuilder);
            return this;
        }

        default public InfinispanComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public InfinispanComponentBuilder customListener(InfinispanRemoteCustomListener customListener) {
            this.doSetProperty("customListener", customListener);
            return this;
        }

        default public InfinispanComponentBuilder eventTypes(String eventTypes) {
            this.doSetProperty("eventTypes", eventTypes);
            return this;
        }

        default public InfinispanComponentBuilder defaultValue(Object defaultValue) {
            this.doSetProperty("defaultValue", defaultValue);
            return this;
        }

        default public InfinispanComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public InfinispanComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public InfinispanComponentBuilder oldValue(Object oldValue) {
            this.doSetProperty("oldValue", oldValue);
            return this;
        }

        default public InfinispanComponentBuilder operation(InfinispanOperation operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public InfinispanComponentBuilder value(Object value) {
            this.doSetProperty("value", value);
            return this;
        }

        default public InfinispanComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public InfinispanComponentBuilder cacheContainer(RemoteCacheManager cacheContainer) {
            this.doSetProperty("cacheContainer", cacheContainer);
            return this;
        }

        default public InfinispanComponentBuilder cacheContainerConfiguration(Configuration cacheContainerConfiguration) {
            this.doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }

        default public InfinispanComponentBuilder configurationProperties(Map<String, String> configurationProperties) {
            this.doSetProperty("configurationProperties", configurationProperties);
            return this;
        }

        default public InfinispanComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public InfinispanComponentBuilder flags(String flags) {
            this.doSetProperty("flags", flags);
            return this;
        }

        default public InfinispanComponentBuilder remappingFunction(BiFunction remappingFunction) {
            this.doSetProperty("remappingFunction", remappingFunction);
            return this;
        }

        default public InfinispanComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public InfinispanComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public InfinispanComponentBuilder saslMechanism(String saslMechanism) {
            this.doSetProperty("saslMechanism", saslMechanism);
            return this;
        }

        default public InfinispanComponentBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public InfinispanComponentBuilder securityRealm(String securityRealm) {
            this.doSetProperty("securityRealm", securityRealm);
            return this;
        }

        default public InfinispanComponentBuilder securityServerName(String securityServerName) {
            this.doSetProperty("securityServerName", securityServerName);
            return this;
        }

        default public InfinispanComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

