/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.salesforce.eventbus.protobuf.ReplayPreset;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.NotFoundBehaviour;
import org.apache.camel.component.salesforce.PubSubDeserializeType;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.dto.EventSchemaFormatEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface SalesforceComponentBuilderFactory {
    public static SalesforceComponentBuilder salesforce() {
        return new SalesforceComponentBuilderImpl();
    }

    public static class SalesforceComponentBuilderImpl
    extends AbstractComponentBuilder<SalesforceComponent>
    implements SalesforceComponentBuilder {
        @Override
        protected SalesforceComponent buildConcreteComponent() {
            return new SalesforceComponent();
        }

        private SalesforceEndpointConfig getOrCreateConfiguration(SalesforceComponent component) {
            if (component.getConfig() == null) {
                component.setConfig(new SalesforceEndpointConfig());
            }
            return component.getConfig();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "apexMethod": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setApexMethod((String)value);
                    return true;
                }
                case "apexQueryParams": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setApexQueryParams((Map)value);
                    return true;
                }
                case "apiVersion": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setApiVersion((String)value);
                    return true;
                }
                case "backoffIncrement": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setBackoffIncrement(((Long)value).longValue());
                    return true;
                }
                case "batchId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setBatchId((String)value);
                    return true;
                }
                case "contentType": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setContentType((ContentType)value);
                    return true;
                }
                case "defaultReplayId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setDefaultReplayId((Long)value);
                    return true;
                }
                case "fallBackReplayId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setFallBackReplayId((Long)value);
                    return true;
                }
                case "format": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setFormat((PayloadFormat)value);
                    return true;
                }
                case "httpClient": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setHttpClient((SalesforceHttpClient)value);
                    return true;
                }
                case "httpClientConnectionTimeout": {
                    ((SalesforceComponent)component).setHttpClientConnectionTimeout(((Long)value).longValue());
                    return true;
                }
                case "httpClientIdleTimeout": {
                    ((SalesforceComponent)component).setHttpClientIdleTimeout(((Long)value).longValue());
                    return true;
                }
                case "httpMaxContentLength": {
                    ((SalesforceComponent)component).setHttpMaxContentLength((Integer)value);
                    return true;
                }
                case "httpRequestBufferSize": {
                    ((SalesforceComponent)component).setHttpRequestBufferSize((Integer)value);
                    return true;
                }
                case "httpRequestTimeout": {
                    ((SalesforceComponent)component).setHttpRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "includeDetails": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setIncludeDetails((Boolean)value);
                    return true;
                }
                case "initialReplayIdMap": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setInitialReplayIdMap((Map)value);
                    return true;
                }
                case "instanceId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setInstanceId((String)value);
                    return true;
                }
                case "jobId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setJobId((String)value);
                    return true;
                }
                case "limit": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setLimit((Integer)value);
                    return true;
                }
                case "locator": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setLocator((String)value);
                    return true;
                }
                case "maxBackoff": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setMaxBackoff(((Long)value).longValue());
                    return true;
                }
                case "maxRecords": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setMaxRecords((Integer)value);
                    return true;
                }
                case "notFoundBehaviour": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotFoundBehaviour((NotFoundBehaviour)value);
                    return true;
                }
                case "notifyForFields": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForFields((NotifyForFieldsEnum)value);
                    return true;
                }
                case "notifyForOperationCreate": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForOperationCreate((Boolean)value);
                    return true;
                }
                case "notifyForOperationDelete": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForOperationDelete((Boolean)value);
                    return true;
                }
                case "notifyForOperations": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForOperations((NotifyForOperationsEnum)value);
                    return true;
                }
                case "notifyForOperationUndelete": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForOperationUndelete((Boolean)value);
                    return true;
                }
                case "notifyForOperationUpdate": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setNotifyForOperationUpdate((Boolean)value);
                    return true;
                }
                case "objectMapper": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setObjectMapper((ObjectMapper)value);
                    return true;
                }
                case "packages": {
                    ((SalesforceComponent)component).setPackages((String)value);
                    return true;
                }
                case "pkChunking": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPkChunking((Boolean)value);
                    return true;
                }
                case "pkChunkingChunkSize": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPkChunkingChunkSize((Integer)value);
                    return true;
                }
                case "pkChunkingParent": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPkChunkingParent((String)value);
                    return true;
                }
                case "pkChunkingStartRow": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPkChunkingStartRow((String)value);
                    return true;
                }
                case "queryLocator": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setQueryLocator((String)value);
                    return true;
                }
                case "rawPayload": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setRawPayload(((Boolean)value).booleanValue());
                    return true;
                }
                case "reportId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setReportId((String)value);
                    return true;
                }
                case "reportMetadata": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setReportMetadata((ReportMetadata)value);
                    return true;
                }
                case "resultId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setResultId((String)value);
                    return true;
                }
                case "sObjectBlobFieldName": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectBlobFieldName((String)value);
                    return true;
                }
                case "sObjectClass": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectClass((String)value);
                    return true;
                }
                case "sObjectFields": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectFields((String)value);
                    return true;
                }
                case "sObjectId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectId((String)value);
                    return true;
                }
                case "sObjectIdName": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectIdName((String)value);
                    return true;
                }
                case "sObjectIdValue": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectIdValue((String)value);
                    return true;
                }
                case "sObjectName": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectName((String)value);
                    return true;
                }
                case "sObjectQuery": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectQuery((String)value);
                    return true;
                }
                case "sObjectSearch": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setSObjectSearch((String)value);
                    return true;
                }
                case "streamQueryResult": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setStreamQueryResult((Boolean)value);
                    return true;
                }
                case "updateTopic": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setUpdateTopic(((Boolean)value).booleanValue());
                    return true;
                }
                case "config": {
                    ((SalesforceComponent)component).setConfig((SalesforceEndpointConfig)value);
                    return true;
                }
                case "httpClientProperties": {
                    ((SalesforceComponent)component).setHttpClientProperties((Map)value);
                    return true;
                }
                case "longPollingTransportProperties": {
                    ((SalesforceComponent)component).setLongPollingTransportProperties((Map)value);
                    return true;
                }
                case "workerPoolMaxSize": {
                    ((SalesforceComponent)component).setWorkerPoolMaxSize(((Integer)value).intValue());
                    return true;
                }
                case "workerPoolSize": {
                    ((SalesforceComponent)component).setWorkerPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((SalesforceComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "pubSubBatchSize": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPubSubBatchSize(((Integer)value).intValue());
                    return true;
                }
                case "pubSubDeserializeType": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPubSubDeserializeType((PubSubDeserializeType)value);
                    return true;
                }
                case "pubSubPojoClass": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setPubSubPojoClass((String)value);
                    return true;
                }
                case "replayPreset": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setReplayPreset((ReplayPreset)value);
                    return true;
                }
                case "allOrNone": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setAllOrNone(((Boolean)value).booleanValue());
                    return true;
                }
                case "apexUrl": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setApexUrl((String)value);
                    return true;
                }
                case "compositeMethod": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setCompositeMethod((String)value);
                    return true;
                }
                case "eventName": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setEventName((String)value);
                    return true;
                }
                case "eventSchemaFormat": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setEventSchemaFormat((EventSchemaFormatEnum)value);
                    return true;
                }
                case "eventSchemaId": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setEventSchemaId((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SalesforceComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "rawHttpHeaders": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setRawHttpHeaders((String)value);
                    return true;
                }
                case "rawMethod": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setRawMethod((String)value);
                    return true;
                }
                case "rawPath": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setRawPath((String)value);
                    return true;
                }
                case "rawQueryParameters": {
                    this.getOrCreateConfiguration((SalesforceComponent)component).setRawQueryParameters((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((SalesforceComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpProxyExcludedAddresses": {
                    ((SalesforceComponent)component).setHttpProxyExcludedAddresses((Set)value);
                    return true;
                }
                case "httpProxyHost": {
                    ((SalesforceComponent)component).setHttpProxyHost((String)value);
                    return true;
                }
                case "httpProxyIncludedAddresses": {
                    ((SalesforceComponent)component).setHttpProxyIncludedAddresses((Set)value);
                    return true;
                }
                case "httpProxyPort": {
                    ((SalesforceComponent)component).setHttpProxyPort((Integer)value);
                    return true;
                }
                case "httpProxySocks4": {
                    ((SalesforceComponent)component).setHttpProxySocks4(((Boolean)value).booleanValue());
                    return true;
                }
                case "authenticationType": {
                    ((SalesforceComponent)component).setAuthenticationType((AuthenticationType)value);
                    return true;
                }
                case "clientId": {
                    ((SalesforceComponent)component).setClientId((String)value);
                    return true;
                }
                case "clientSecret": {
                    ((SalesforceComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "httpProxyAuthUri": {
                    ((SalesforceComponent)component).setHttpProxyAuthUri((String)value);
                    return true;
                }
                case "httpProxyPassword": {
                    ((SalesforceComponent)component).setHttpProxyPassword((String)value);
                    return true;
                }
                case "httpProxyRealm": {
                    ((SalesforceComponent)component).setHttpProxyRealm((String)value);
                    return true;
                }
                case "httpProxySecure": {
                    ((SalesforceComponent)component).setHttpProxySecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpProxyUseDigestAuth": {
                    ((SalesforceComponent)component).setHttpProxyUseDigestAuth(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpProxyUsername": {
                    ((SalesforceComponent)component).setHttpProxyUsername((String)value);
                    return true;
                }
                case "instanceUrl": {
                    ((SalesforceComponent)component).setInstanceUrl((String)value);
                    return true;
                }
                case "jwtAudience": {
                    ((SalesforceComponent)component).setJwtAudience((String)value);
                    return true;
                }
                case "keystore": {
                    ((SalesforceComponent)component).setKeystore((KeyStoreParameters)value);
                    return true;
                }
                case "lazyLogin": {
                    ((SalesforceComponent)component).setLazyLogin(((Boolean)value).booleanValue());
                    return true;
                }
                case "loginConfig": {
                    ((SalesforceComponent)component).setLoginConfig((SalesforceLoginConfig)value);
                    return true;
                }
                case "loginUrl": {
                    ((SalesforceComponent)component).setLoginUrl((String)value);
                    return true;
                }
                case "password": {
                    ((SalesforceComponent)component).setPassword((String)value);
                    return true;
                }
                case "pubSubHost": {
                    ((SalesforceComponent)component).setPubSubHost((String)value);
                    return true;
                }
                case "pubSubPort": {
                    ((SalesforceComponent)component).setPubSubPort(((Integer)value).intValue());
                    return true;
                }
                case "refreshToken": {
                    ((SalesforceComponent)component).setRefreshToken((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((SalesforceComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((SalesforceComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "userName": {
                    ((SalesforceComponent)component).setUserName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SalesforceComponentBuilder
    extends ComponentBuilder<SalesforceComponent> {
        default public SalesforceComponentBuilder apexMethod(String apexMethod) {
            this.doSetProperty("apexMethod", apexMethod);
            return this;
        }

        default public SalesforceComponentBuilder apexQueryParams(Map<String, Object> apexQueryParams) {
            this.doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }

        default public SalesforceComponentBuilder apiVersion(String apiVersion) {
            this.doSetProperty("apiVersion", apiVersion);
            return this;
        }

        default public SalesforceComponentBuilder backoffIncrement(long backoffIncrement) {
            this.doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }

        default public SalesforceComponentBuilder batchId(String batchId) {
            this.doSetProperty("batchId", batchId);
            return this;
        }

        default public SalesforceComponentBuilder contentType(ContentType contentType) {
            this.doSetProperty("contentType", contentType);
            return this;
        }

        default public SalesforceComponentBuilder defaultReplayId(Long defaultReplayId) {
            this.doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }

        default public SalesforceComponentBuilder fallBackReplayId(Long fallBackReplayId) {
            this.doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }

        default public SalesforceComponentBuilder format(PayloadFormat format) {
            this.doSetProperty("format", format);
            return this;
        }

        default public SalesforceComponentBuilder httpClient(SalesforceHttpClient httpClient) {
            this.doSetProperty("httpClient", httpClient);
            return this;
        }

        default public SalesforceComponentBuilder httpClientConnectionTimeout(long httpClientConnectionTimeout) {
            this.doSetProperty("httpClientConnectionTimeout", httpClientConnectionTimeout);
            return this;
        }

        default public SalesforceComponentBuilder httpClientIdleTimeout(long httpClientIdleTimeout) {
            this.doSetProperty("httpClientIdleTimeout", httpClientIdleTimeout);
            return this;
        }

        default public SalesforceComponentBuilder httpMaxContentLength(Integer httpMaxContentLength) {
            this.doSetProperty("httpMaxContentLength", httpMaxContentLength);
            return this;
        }

        default public SalesforceComponentBuilder httpRequestBufferSize(Integer httpRequestBufferSize) {
            this.doSetProperty("httpRequestBufferSize", httpRequestBufferSize);
            return this;
        }

        default public SalesforceComponentBuilder httpRequestTimeout(long httpRequestTimeout) {
            this.doSetProperty("httpRequestTimeout", httpRequestTimeout);
            return this;
        }

        default public SalesforceComponentBuilder includeDetails(Boolean includeDetails) {
            this.doSetProperty("includeDetails", includeDetails);
            return this;
        }

        default public SalesforceComponentBuilder initialReplayIdMap(Map<String, Long> initialReplayIdMap) {
            this.doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }

        default public SalesforceComponentBuilder instanceId(String instanceId) {
            this.doSetProperty("instanceId", instanceId);
            return this;
        }

        default public SalesforceComponentBuilder jobId(String jobId) {
            this.doSetProperty("jobId", jobId);
            return this;
        }

        default public SalesforceComponentBuilder limit(Integer limit) {
            this.doSetProperty("limit", limit);
            return this;
        }

        default public SalesforceComponentBuilder locator(String locator) {
            this.doSetProperty("locator", locator);
            return this;
        }

        default public SalesforceComponentBuilder maxBackoff(long maxBackoff) {
            this.doSetProperty("maxBackoff", maxBackoff);
            return this;
        }

        default public SalesforceComponentBuilder maxRecords(Integer maxRecords) {
            this.doSetProperty("maxRecords", maxRecords);
            return this;
        }

        default public SalesforceComponentBuilder notFoundBehaviour(NotFoundBehaviour notFoundBehaviour) {
            this.doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }

        default public SalesforceComponentBuilder notifyForFields(NotifyForFieldsEnum notifyForFields) {
            this.doSetProperty("notifyForFields", notifyForFields);
            return this;
        }

        default public SalesforceComponentBuilder notifyForOperationCreate(Boolean notifyForOperationCreate) {
            this.doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }

        default public SalesforceComponentBuilder notifyForOperationDelete(Boolean notifyForOperationDelete) {
            this.doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }

        default public SalesforceComponentBuilder notifyForOperations(NotifyForOperationsEnum notifyForOperations) {
            this.doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }

        default public SalesforceComponentBuilder notifyForOperationUndelete(Boolean notifyForOperationUndelete) {
            this.doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }

        default public SalesforceComponentBuilder notifyForOperationUpdate(Boolean notifyForOperationUpdate) {
            this.doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }

        default public SalesforceComponentBuilder objectMapper(ObjectMapper objectMapper) {
            this.doSetProperty("objectMapper", objectMapper);
            return this;
        }

        default public SalesforceComponentBuilder packages(String packages) {
            this.doSetProperty("packages", packages);
            return this;
        }

        default public SalesforceComponentBuilder pkChunking(Boolean pkChunking) {
            this.doSetProperty("pkChunking", pkChunking);
            return this;
        }

        default public SalesforceComponentBuilder pkChunkingChunkSize(Integer pkChunkingChunkSize) {
            this.doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }

        default public SalesforceComponentBuilder pkChunkingParent(String pkChunkingParent) {
            this.doSetProperty("pkChunkingParent", pkChunkingParent);
            return this;
        }

        default public SalesforceComponentBuilder pkChunkingStartRow(String pkChunkingStartRow) {
            this.doSetProperty("pkChunkingStartRow", pkChunkingStartRow);
            return this;
        }

        default public SalesforceComponentBuilder queryLocator(String queryLocator) {
            this.doSetProperty("queryLocator", queryLocator);
            return this;
        }

        default public SalesforceComponentBuilder rawPayload(boolean rawPayload) {
            this.doSetProperty("rawPayload", rawPayload);
            return this;
        }

        default public SalesforceComponentBuilder reportId(String reportId) {
            this.doSetProperty("reportId", reportId);
            return this;
        }

        default public SalesforceComponentBuilder reportMetadata(ReportMetadata reportMetadata) {
            this.doSetProperty("reportMetadata", reportMetadata);
            return this;
        }

        default public SalesforceComponentBuilder resultId(String resultId) {
            this.doSetProperty("resultId", resultId);
            return this;
        }

        default public SalesforceComponentBuilder sObjectBlobFieldName(String sObjectBlobFieldName) {
            this.doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }

        default public SalesforceComponentBuilder sObjectClass(String sObjectClass) {
            this.doSetProperty("sObjectClass", sObjectClass);
            return this;
        }

        default public SalesforceComponentBuilder sObjectFields(String sObjectFields) {
            this.doSetProperty("sObjectFields", sObjectFields);
            return this;
        }

        default public SalesforceComponentBuilder sObjectId(String sObjectId) {
            this.doSetProperty("sObjectId", sObjectId);
            return this;
        }

        default public SalesforceComponentBuilder sObjectIdName(String sObjectIdName) {
            this.doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }

        default public SalesforceComponentBuilder sObjectIdValue(String sObjectIdValue) {
            this.doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }

        default public SalesforceComponentBuilder sObjectName(String sObjectName) {
            this.doSetProperty("sObjectName", sObjectName);
            return this;
        }

        default public SalesforceComponentBuilder sObjectQuery(String sObjectQuery) {
            this.doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }

        default public SalesforceComponentBuilder sObjectSearch(String sObjectSearch) {
            this.doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }

        default public SalesforceComponentBuilder streamQueryResult(Boolean streamQueryResult) {
            this.doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }

        default public SalesforceComponentBuilder updateTopic(boolean updateTopic) {
            this.doSetProperty("updateTopic", updateTopic);
            return this;
        }

        default public SalesforceComponentBuilder config(SalesforceEndpointConfig config) {
            this.doSetProperty("config", config);
            return this;
        }

        default public SalesforceComponentBuilder httpClientProperties(Map<String, Object> httpClientProperties) {
            this.doSetProperty("httpClientProperties", httpClientProperties);
            return this;
        }

        default public SalesforceComponentBuilder longPollingTransportProperties(Map<String, Object> longPollingTransportProperties) {
            this.doSetProperty("longPollingTransportProperties", longPollingTransportProperties);
            return this;
        }

        default public SalesforceComponentBuilder workerPoolMaxSize(int workerPoolMaxSize) {
            this.doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }

        default public SalesforceComponentBuilder workerPoolSize(int workerPoolSize) {
            this.doSetProperty("workerPoolSize", workerPoolSize);
            return this;
        }

        default public SalesforceComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SalesforceComponentBuilder pubSubBatchSize(int pubSubBatchSize) {
            this.doSetProperty("pubSubBatchSize", pubSubBatchSize);
            return this;
        }

        default public SalesforceComponentBuilder pubSubDeserializeType(PubSubDeserializeType pubSubDeserializeType) {
            this.doSetProperty("pubSubDeserializeType", pubSubDeserializeType);
            return this;
        }

        default public SalesforceComponentBuilder pubSubPojoClass(String pubSubPojoClass) {
            this.doSetProperty("pubSubPojoClass", pubSubPojoClass);
            return this;
        }

        default public SalesforceComponentBuilder replayPreset(ReplayPreset replayPreset) {
            this.doSetProperty("replayPreset", replayPreset);
            return this;
        }

        default public SalesforceComponentBuilder allOrNone(boolean allOrNone) {
            this.doSetProperty("allOrNone", allOrNone);
            return this;
        }

        default public SalesforceComponentBuilder apexUrl(String apexUrl) {
            this.doSetProperty("apexUrl", apexUrl);
            return this;
        }

        default public SalesforceComponentBuilder compositeMethod(String compositeMethod) {
            this.doSetProperty("compositeMethod", compositeMethod);
            return this;
        }

        default public SalesforceComponentBuilder eventName(String eventName) {
            this.doSetProperty("eventName", eventName);
            return this;
        }

        default public SalesforceComponentBuilder eventSchemaFormat(EventSchemaFormatEnum eventSchemaFormat) {
            this.doSetProperty("eventSchemaFormat", eventSchemaFormat);
            return this;
        }

        default public SalesforceComponentBuilder eventSchemaId(String eventSchemaId) {
            this.doSetProperty("eventSchemaId", eventSchemaId);
            return this;
        }

        default public SalesforceComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SalesforceComponentBuilder rawHttpHeaders(String rawHttpHeaders) {
            this.doSetProperty("rawHttpHeaders", rawHttpHeaders);
            return this;
        }

        default public SalesforceComponentBuilder rawMethod(String rawMethod) {
            this.doSetProperty("rawMethod", rawMethod);
            return this;
        }

        default public SalesforceComponentBuilder rawPath(String rawPath) {
            this.doSetProperty("rawPath", rawPath);
            return this;
        }

        default public SalesforceComponentBuilder rawQueryParameters(String rawQueryParameters) {
            this.doSetProperty("rawQueryParameters", rawQueryParameters);
            return this;
        }

        default public SalesforceComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyExcludedAddresses(Set<String> httpProxyExcludedAddresses) {
            this.doSetProperty("httpProxyExcludedAddresses", httpProxyExcludedAddresses);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyHost(String httpProxyHost) {
            this.doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyIncludedAddresses(Set<String> httpProxyIncludedAddresses) {
            this.doSetProperty("httpProxyIncludedAddresses", httpProxyIncludedAddresses);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyPort(Integer httpProxyPort) {
            this.doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }

        default public SalesforceComponentBuilder httpProxySocks4(boolean httpProxySocks4) {
            this.doSetProperty("httpProxySocks4", httpProxySocks4);
            return this;
        }

        default public SalesforceComponentBuilder authenticationType(AuthenticationType authenticationType) {
            this.doSetProperty("authenticationType", authenticationType);
            return this;
        }

        default public SalesforceComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public SalesforceComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyAuthUri(String httpProxyAuthUri) {
            this.doSetProperty("httpProxyAuthUri", httpProxyAuthUri);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyPassword(String httpProxyPassword) {
            this.doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyRealm(String httpProxyRealm) {
            this.doSetProperty("httpProxyRealm", httpProxyRealm);
            return this;
        }

        default public SalesforceComponentBuilder httpProxySecure(boolean httpProxySecure) {
            this.doSetProperty("httpProxySecure", httpProxySecure);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyUseDigestAuth(boolean httpProxyUseDigestAuth) {
            this.doSetProperty("httpProxyUseDigestAuth", httpProxyUseDigestAuth);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyUsername(String httpProxyUsername) {
            this.doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }

        default public SalesforceComponentBuilder instanceUrl(String instanceUrl) {
            this.doSetProperty("instanceUrl", instanceUrl);
            return this;
        }

        default public SalesforceComponentBuilder jwtAudience(String jwtAudience) {
            this.doSetProperty("jwtAudience", jwtAudience);
            return this;
        }

        default public SalesforceComponentBuilder keystore(KeyStoreParameters keystore) {
            this.doSetProperty("keystore", keystore);
            return this;
        }

        default public SalesforceComponentBuilder lazyLogin(boolean lazyLogin) {
            this.doSetProperty("lazyLogin", lazyLogin);
            return this;
        }

        default public SalesforceComponentBuilder loginConfig(SalesforceLoginConfig loginConfig) {
            this.doSetProperty("loginConfig", loginConfig);
            return this;
        }

        default public SalesforceComponentBuilder loginUrl(String loginUrl) {
            this.doSetProperty("loginUrl", loginUrl);
            return this;
        }

        default public SalesforceComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public SalesforceComponentBuilder pubSubHost(String pubSubHost) {
            this.doSetProperty("pubSubHost", pubSubHost);
            return this;
        }

        default public SalesforceComponentBuilder pubSubPort(int pubSubPort) {
            this.doSetProperty("pubSubPort", pubSubPort);
            return this;
        }

        default public SalesforceComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }

        default public SalesforceComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public SalesforceComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public SalesforceComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }
    }
}

