/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.List;
import java.util.Map;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.Record;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.flatpack.FlatpackConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;

@DeferredContextBinding
public final class FlatpackConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        FlatpackConverterLoader.addTypeConverter(registry, String.class, DataSet.class, false, (type, exchange, value) -> FlatpackConverter.toString((DataSet)value));
        FlatpackConverterLoader.addTypeConverter(registry, List.class, DataSet.class, false, (type, exchange, value) -> FlatpackConverter.toList((DataSet)value));
        FlatpackConverterLoader.addTypeConverter(registry, Map.class, Record.class, false, (type, exchange, value) -> FlatpackConverter.toMap((Record)value));
        FlatpackConverterLoader.addTypeConverter(registry, Document.class, DataSet.class, false, (type, exchange, value) -> FlatpackConverter.toDocument((DataSet)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

