/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.commons.net.ftp.FTPFile;

@org.apache.camel.spi.annotations.Component(value="ftp")
public class FtpComponent
extends RemoteFileComponent<FTPFile> {
    public FtpComponent() {
    }

    public FtpComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpConfiguration config = new FtpConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory((Component)this, config);
        FtpEndpoint<FTPFile> answer = new FtpEndpoint<FTPFile>(uri, (RemoteFileComponent<FTPFile>)this, config);
        this.extractAndSetFtpClientConfigParameters(parameters, answer);
        this.extractAndSetFtpClientParameters(parameters, answer);
        return answer;
    }

    protected String getBaseUri(String uri) {
        String baseUri = uri;
        if (uri.indexOf(63) != -1) {
            baseUri = uri.substring(0, uri.indexOf(63));
        }
        return baseUri;
    }

    protected void extractAndSetFtpClientConfigParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (PropertiesHelper.hasProperties(parameters, (String)"ftpClientConfig.")) {
            Map param = PropertiesHelper.extractProperties(parameters, (String)"ftpClientConfig.");
            answer.setFtpClientConfigParameters(param);
        }
    }

    protected void extractAndSetFtpClientParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (PropertiesHelper.hasProperties(parameters, (String)"ftpClient.")) {
            Map param = PropertiesHelper.extractProperties(parameters, (String)"ftpClient.");
            answer.setFtpClientParameters(param);
        }
    }

    protected void setProperties(Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        Object siteCommand = parameters.remove("siteCommand");
        if (siteCommand != null) {
            String cmd = (String)PropertyConfigurerSupport.property((CamelContext)this.getCamelContext(), String.class, (Object)siteCommand);
            if (EndpointHelper.isReferenceParameter((String)cmd)) {
                cmd = (String)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)cmd, String.class);
            }
            ((FtpEndpoint)endpoint).getConfiguration().setSiteCommand(cmd);
        }
        super.setProperties(endpoint, parameters);
    }

    protected void afterPropertiesSet(GenericFileEndpoint<FTPFile> endpoint) throws Exception {
    }
}

