/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;

public enum HttpMethods implements Expression
{
    GET(false),
    PATCH(true),
    POST(true),
    PUT(true),
    DELETE(false),
    HEAD(false),
    OPTIONS(false),
    TRACE(false);

    final boolean entity;

    private HttpMethods(boolean entity) {
        this.entity = entity;
    }

    public HttpUriRequest createMethod(String url) {
        return this.createMethod(URI.create(url));
    }

    public HttpUriRequest createMethod(URI uri) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new HttpGet(uri);
            case 1 -> new HttpPatch(uri);
            case 2 -> new HttpPost(uri);
            case 3 -> new HttpPut(uri);
            case 4 -> new HttpDelete(uri);
            case 5 -> new HttpHead(uri);
            case 6 -> new HttpOptions(uri);
            case 7 -> new HttpTrace(uri);
        };
    }

    public final boolean isEntityEnclosing() {
        return this.entity;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)ExpressionBuilder.constantExpression((Object)this.name()).evaluate(exchange, type);
    }
}

