/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.Attachment;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.IOHelper;

public class SplitAttachmentsExpression
extends ExpressionAdapter {
    public static final String HEADER_NAME = "CamelSplitAttachmentId";
    private boolean extractAttachments;

    public SplitAttachmentsExpression() {
    }

    public SplitAttachmentsExpression(boolean extractAttachments) {
        this.extractAttachments = extractAttachments;
    }

    public Object evaluate(Exchange exchange) {
        if (exchange.getIn().getAttachments().isEmpty()) {
            return null;
        }
        try {
            ArrayList<Message> answer = new ArrayList<Message>();
            Message inMessage = exchange.getIn();
            for (Map.Entry entry : inMessage.getAttachmentObjects().entrySet()) {
                Message attachmentMessage = this.extractAttachments ? this.extractAttachment(inMessage, (String)entry.getKey()) : this.splitAttachment(inMessage, (String)entry.getKey(), (Attachment)entry.getValue());
                if (attachmentMessage == null) continue;
                answer.add(attachmentMessage);
            }
            return answer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Unable to split attachments from MimeMultipart message", (Throwable)e);
        }
    }

    private Message splitAttachment(Message inMessage, String attachmentName, Attachment attachmentHandler) {
        Message copy = inMessage.copy();
        Map attachments = copy.getAttachmentObjects();
        attachments.clear();
        attachments.put(attachmentName, attachmentHandler);
        copy.setHeader(HEADER_NAME, (Object)attachmentName);
        return copy;
    }

    private Message extractAttachment(Message inMessage, String attachmentName) throws Exception {
        DefaultMessage outMessage = new DefaultMessage();
        outMessage.setHeader(HEADER_NAME, (Object)attachmentName);
        Object attachment = inMessage.getAttachment(attachmentName).getContent();
        if (attachment instanceof InputStream) {
            outMessage.setBody((Object)this.readMimePart((InputStream)attachment));
            return outMessage;
        }
        if (attachment instanceof String || attachment instanceof byte[]) {
            outMessage.setBody(attachment);
            return outMessage;
        }
        return null;
    }

    private byte[] readMimePart(InputStream mimePartStream) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)mimePartStream, (OutputStream)bos);
        return bos.toByteArray();
    }

    public boolean isExtractAttachments() {
        return this.extractAttachments;
    }

    public void setExtractAttachments(boolean extractAttachments) {
        this.extractAttachments = extractAttachments;
    }
}

