/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

@Mojo(name="generate-invoke-on-header", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateInvokeOnHeaderMojo
extends AbstractGeneratorMojo {
    public static final DotName HEADER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.InvokeOnHeader");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ((index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) == null) {
            return;
        }
        HashMap classes = new HashMap();
        List annotations = index.getAnnotations(HEADER_ANNOTATION);
        annotations.forEach(a -> {
            boolean isVoid;
            String currentClass = a.target().asMethod().declaringClass().name().toString();
            String value = a.value().asString();
            MethodInfo mi = a.target().asMethod();
            InvokeOnHeaderModel model = new InvokeOnHeaderModel();
            model.setKey(value);
            model.setMethodName(mi.name());
            boolean bl = isVoid = Type.Kind.VOID == mi.returnType().kind();
            if (isVoid) {
                model.setReturnType("VOID");
            } else {
                model.setReturnType(mi.returnType().toString());
            }
            for (Type type : mi.parameterTypes()) {
                String arg = type.name().toString();
                model.addArgs(arg);
            }
            Set set = classes.computeIfAbsent(currentClass, k -> new TreeSet<InvokeOnHeaderModel>(Comparator.comparing(InvokeOnHeaderModel::getKey)));
            set.add(model);
        });
        try {
            for (Map.Entry entry : classes.entrySet()) {
                this.createInvokeOnHeaderFactory((String)entry.getKey(), (Set)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    protected void createInvokeOnHeaderFactory(String fqn, Set<InvokeOnHeaderModel> models) throws IOException {
        int pos = fqn.lastIndexOf(46);
        String pn = fqn.substring(0, pos);
        String cn = fqn.substring(pos + 1) + "InvokeOnHeaderFactory";
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("pn", pn);
        ctx.put("cn", cn);
        ctx.put("en", fqn);
        ctx.put("pfqn", fqn);
        ctx.put("models", models);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/invoke-on-header.vm", ctx);
        String fileName = pn.replace('.', '/') + "/" + cn + ".java";
        boolean updated = this.updateResource(this.sourcesOutputDir.toPath(), fileName, source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
        String tfqn = pn + "." + cn;
        this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/invoke-on-header/" + fqn, "# Generated by camel build tools - do NOT edit this file!\nclass=" + tfqn + "\n");
    }

    public String bindArg(String type) {
        return switch (type) {
            case "org.apache.camel.Exchange" -> "exchange";
            case "org.apache.camel.Message" -> "exchange.getMessage()";
            case "org.apache.camel.AsyncCallback" -> "callback";
            case "org.apache.camel.CamelContext" -> "exchange.getContext()";
            default -> "exchange.getMessage().getBody(" + type + ".class)";
        };
    }

    public static class InvokeOnHeaderModel {
        private String key;
        private String methodName;
        private String returnType;
        private final List<String> args = new ArrayList<String>();

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void addArgs(String arg) {
            this.args.add(arg);
        }
    }
}

