/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MojoHelper;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.JsonObject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

@Mojo(name="generate-pojo-bean", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GeneratePojoBeanMojo
extends AbstractGeneratorMojo {
    public static final DotName METADATA = DotName.createSimple((String)"org.apache.camel.spi.Metadata");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ((index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) == null) {
            return;
        }
        ArrayList<BeanPojoModel> models = new ArrayList<BeanPojoModel>();
        List annotations = index.getAnnotations(METADATA);
        annotations.forEach(a -> {
            String label = MojoHelper.annotationValue(a, "label");
            if ("bean".equals(label)) {
                BeanPojoModel model = new BeanPojoModel();
                ClassInfo ci = a.target().asClass();
                model.setName(ci.simpleName());
                boolean deprecated = ci.hasAnnotation(Deprecated.class);
                String title = MojoHelper.annotationValue(a, "title");
                if (title == null) {
                    title = Strings.camelCaseToDash((String)model.getName());
                    title = Strings.camelDashToTitle((String)title);
                }
                model.setTitle(title);
                model.setClassName(ci.name().toString());
                model.setDeprecated(deprecated);
                model.setDescription(MojoHelper.annotationValue(a, "description"));
                model.setInterfaceName(MojoHelper.annotationValue(a, "annotations", "interfaceName"));
                if (model.getInterfaceName() == null) {
                    model.setInterfaceName(GeneratePojoBeanMojo.interfaceName(index, ci));
                }
                while (ci != null) {
                    this.extractFields(ci, model);
                    DotName dn = ci.superName();
                    if (dn == null) continue;
                    ci = index.getClassByName(dn);
                }
                models.add(model);
            }
        });
        models.sort(Comparator.comparing(BeanPojoModel::getName));
        if (!models.isEmpty()) {
            try {
                StringJoiner names = new StringJoiner(" ");
                for (BeanPojoModel model : models) {
                    names.add(model.getName());
                    JsonObject jo = this.asJsonObject(model);
                    String json = JsonMapper.serialize((Object)jo);
                    String fn = this.sanitizeFileName(model.getName()) + ".json";
                    boolean updated = this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/bean/" + fn, json + "\n");
                    if (!updated) continue;
                    this.getLog().info((CharSequence)("Updated bean json: " + model.getName()));
                }
                File camelMetaDir = new File(this.resourcesOutputDir, "META-INF/services/org/apache/camel/");
                int count = models.size();
                String properties = GeneratePojoBeanMojo.createProperties(this.project, "bean", names.toString());
                this.updateResource(camelMetaDir.toPath(), "bean.properties", properties);
                this.getLog().info((CharSequence)("Generated bean.properties containing " + count + " Camel " + (count > 1 ? "beans: " : "bean: ") + String.valueOf(names)));
            }
            catch (Exception e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    private void extractFields(ClassInfo ci, BeanPojoModel model) {
        Class<?> classElement = this.loadClass(ci.name().toString());
        List<Field> fields = Stream.of(classElement.getDeclaredFields()).filter(f -> f.getAnnotation(Metadata.class) != null).toList();
        for (Field fi : fields) {
            BeanPojoOptionModel o = new BeanPojoOptionModel();
            Metadata ai = fi.getAnnotation(Metadata.class);
            o.setKind("property");
            o.setName(fi.getName());
            if (!ai.label().isEmpty()) {
                o.setLabel(ai.label());
            }
            if (!ai.defaultValue().isEmpty()) {
                o.setDefaultValue(ai.defaultValue());
            }
            o.setRequired(ai.required());
            String displayName = ai.displayName();
            if (displayName.isEmpty()) {
                displayName = Strings.asTitle((String)o.getName());
            }
            o.setDisplayName(displayName);
            o.setDeprecated(fi.getAnnotation(Deprecated.class) != null);
            o.setAutowired(ai.autowired());
            o.setSecret(ai.secret());
            String javaType = ai.javaType();
            if (javaType.isEmpty()) {
                javaType = fi.getType().getTypeName();
            }
            o.setJavaType(javaType);
            o.setType(MojoHelper.getType(javaType, false, false));
            o.setDescription(ai.description());
            String enums = ai.enums();
            if (!enums.isEmpty()) {
                String[] values = enums.split(",");
                o.setEnums(Stream.of(values).map(String::trim).toList());
            }
            model.addOption(o);
        }
    }

    private static String interfaceName(Index index, ClassInfo target) {
        DotName dn;
        ClassInfo ci;
        for (DotName dn2 : target.interfaceNames()) {
            if (!dn2.packagePrefix().startsWith("org.apache.camel")) continue;
            return dn2.toString();
        }
        if (target.superName() != null && (ci = index.getClassByName(dn = target.superName())) != null) {
            return GeneratePojoBeanMojo.interfaceName(index, ci);
        }
        return null;
    }

    private JsonObject asJsonObject(BeanPojoModel model) {
        JsonObject jo = new JsonObject();
        jo.put((Object)"kind", (Object)"bean");
        jo.put((Object)"name", (Object)model.getName());
        jo.put((Object)"javaType", (Object)model.getClassName());
        if (model.getInterfaceName() != null) {
            jo.put((Object)"interfaceType", (Object)model.getInterfaceName());
        }
        jo.put((Object)"title", (Object)this.asTitle(model.getName()));
        if (model.getDescription() != null) {
            jo.put((Object)"description", (Object)model.getDescription());
        }
        jo.put((Object)"deprecated", (Object)model.isDeprecated());
        jo.put((Object)"groupId", (Object)this.project.getGroupId());
        jo.put((Object)"artifactId", (Object)this.project.getArtifactId());
        jo.put((Object)"version", (Object)this.project.getVersion());
        if (!model.getOptions().isEmpty()) {
            JsonObject options = JsonMapper.asJsonObject(model.getOptions());
            jo.put((Object)"properties", (Object)options);
        }
        JsonObject root = new JsonObject();
        root.put((Object)"bean", (Object)jo);
        return root;
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9+-/]", "-");
    }

    private String asTitle(String name) {
        return Strings.asTitle((String)name);
    }

    private static class BeanPojoModel {
        private String name;
        private String title;
        private String className;
        private String interfaceName;
        private String description;
        private boolean deprecated;
        private final List<BeanPojoOptionModel> options = new ArrayList<BeanPojoOptionModel>();

        private BeanPojoModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public void addOption(BeanPojoOptionModel option) {
            this.options.add(option);
        }

        public List<BeanPojoOptionModel> getOptions() {
            return this.options;
        }
    }

    private static class BeanPojoOptionModel
    extends BaseOptionModel {
        private BeanPojoOptionModel() {
        }
    }
}

