/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="sanity-check", threadSafe=true)
public class SanityCheckGeneratedClassesMojo
extends AbstractGeneratorMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Path generated = this.project.getBasedir().toPath().resolve("src/generated/java");
        if (Files.isDirectory(generated, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(generated, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(clazz -> {
                    String source = SanityCheckGeneratedClassesMojo.read(clazz);
                    if (!source.contains("@Generated")) {
                        this.getLog().warn((CharSequence)("Generated class is missing @Generated: " + String.valueOf(clazz)));
                    }
                });
            }
            catch (Exception e) {
                throw new MojoFailureException("Error sanity checking generated classes", (Throwable)e);
            }
        }
    }

    private static String read(Path p) {
        try {
            return Files.readString(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

