/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import org.apache.camel.maven.packaging.ModelWriterGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-yaml-writer", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class YamlModelWriterGeneratorMojo
extends ModelWriterGeneratorMojo {
    public static final String WRITER_PACKAGE = "org.apache.camel.yaml.out";
    @Parameter(defaultValue="${camel-generate-yaml-writer}")
    protected boolean generateYamlWriter;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.sourcesOutputDir = new File(project.getBasedir(), "src/generated/java");
        this.generateYamlWriter = Boolean.parseBoolean(project.getProperties().getProperty("camel-generate-yaml-writer", "false"));
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        if (!this.generateYamlWriter) {
            return;
        }
        Path javaDir = this.sourcesOutputDir.toPath();
        String parser = this.generateWriter();
        this.updateResource(javaDir, (this.getWriterPackage() + ".ModelWriter").replace('.', '/') + ".java", parser);
    }

    @Override
    String getWriterPackage() {
        return WRITER_PACKAGE;
    }
}

