/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.component.scheduler.SchedulerConsumer;
import org.apache.camel.component.scheduler.SchedulerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="scheduler")
public class SchedulerComponent
extends DefaultComponent {
    private final Map<String, ScheduledExecutorService> executors = new HashMap<String, ScheduledExecutorService>();
    private final Map<String, AtomicInteger> refCounts = new HashMap<String, AtomicInteger>();
    @Metadata(defaultValue="1", label="scheduler")
    private int concurrentTasks = 1;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SchedulerEndpoint answer = new SchedulerEndpoint(uri, this, remaining);
        answer.setConcurrentTasks(this.getConcurrentTasks());
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    public int getConcurrentTasks() {
        return this.concurrentTasks;
    }

    public void setConcurrentTasks(int concurrentTasks) {
        this.concurrentTasks = concurrentTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledExecutorService addConsumer(SchedulerConsumer consumer) {
        ScheduledExecutorService answer;
        String name = consumer.getEndpoint().getName();
        int concurrentTasks = consumer.getEndpoint().getConcurrentTasks();
        Map<String, ScheduledExecutorService> map = this.executors;
        synchronized (map) {
            answer = this.executors.get(name);
            if (answer == null) {
                answer = this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "scheduler://" + name, concurrentTasks);
                this.executors.put(name, answer);
                this.refCounts.put(name, new AtomicInteger(1));
            } else {
                AtomicInteger counter = this.refCounts.get(name);
                if (counter != null) {
                    counter.incrementAndGet();
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConsumer(SchedulerConsumer consumer) {
        String name = consumer.getEndpoint().getName();
        Map<String, ScheduledExecutorService> map = this.executors;
        synchronized (map) {
            AtomicInteger counter = this.refCounts.get(name);
            if (counter != null && counter.decrementAndGet() <= 0) {
                this.refCounts.remove(name);
                ScheduledExecutorService scheduler = this.executors.remove(name);
                if (scheduler != null) {
                    this.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)scheduler);
                }
            }
        }
    }

    protected void doStop() throws Exception {
        Collection<ScheduledExecutorService> collection = this.executors.values();
        for (ScheduledExecutorService scheduler : collection) {
            this.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)scheduler);
        }
        this.executors.clear();
        this.refCounts.clear();
    }
}

