/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.PropertiesHelper;

public abstract class ScheduledPollEndpoint
extends DefaultEndpoint {
    private static final String SPRING_SCHEDULER = "org.apache.camel.spring.pollingconsumer.SpringScheduledPollConsumerScheduler";
    private static final String QUARTZ_SCHEDULER = "org.apache.camel.pollconsumer.quartz.QuartzScheduledPollConsumerScheduler";
    private static final int DEFAULT_INITIAL_DELAY = 1000;
    private static final int DEFAULT_DELAY = 500;
    private transient ScheduledPollConsumerScheduler consumerScheduler;
    @UriParam(defaultValue="true", label="consumer,scheduler", description="Whether the scheduler should be auto started.")
    private boolean startScheduler = true;
    @UriParam(defaultValue="1000", label="consumer,scheduler", description="Milliseconds before the first poll starts.")
    private long initialDelay = -1L;
    @UriParam(defaultValue="500", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = -1L;
    @UriParam(defaultValue="MILLISECONDS", label="consumer,scheduler", description="Time unit for initialDelay and delay options.")
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    @UriParam(defaultValue="true", label="consumer,scheduler", description="Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.")
    private boolean useFixedDelay = true;
    @UriParam(label="consumer,advanced", description="A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.")
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();
    @UriParam(defaultValue="TRACE", label="consumer,scheduler", description="The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that.")
    private LoggingLevel runLoggingLevel = LoggingLevel.TRACE;
    @UriParam(label="consumer", description="If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.")
    private boolean sendEmptyMessageWhenIdle;
    @UriParam(label="consumer,scheduler", description="If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.")
    private boolean greedy;
    @UriParam(defaultValue="none", label="consumer,scheduler", description="To use a cron scheduler from either camel-spring or camel-quartz component. Use value spring or quartz for built in scheduler")
    private Object scheduler = "none";
    @UriParam(prefix="scheduler.", multiValue=true, label="consumer,scheduler", description="To configure additional properties when using a custom scheduler or any of the Quartz, Spring based scheduler.")
    private Map<String, Object> schedulerProperties;
    @UriParam(label="consumer,scheduler", description="Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.")
    private ScheduledExecutorService scheduledExecutorService;
    @UriParam(label="consumer,scheduler", description="To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.")
    private int backoffMultiplier;
    @UriParam(label="consumer,scheduler", description="The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.")
    private int backoffIdleThreshold;
    @UriParam(label="consumer,scheduler", description="The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.")
    private int backoffErrorThreshold;
    @UriParam(label="consumer,scheduler", defaultValue="0", description="Specifies a maximum limit of number of fires. So if you set it to 1, the scheduler will only fire once. If you set it to 5, it will only fire five times. A value of zero or negative means fire forever.")
    private long repeatCount;

    protected ScheduledPollEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    protected ScheduledPollEndpoint() {
    }

    @Override
    protected void configureConsumer(Consumer consumer) throws Exception {
        super.configureConsumer(consumer);
        this.doConfigureConsumer(consumer);
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        this.configureScheduledPollConsumerProperties(options);
        super.configureProperties(options);
    }

    protected void configureScheduledPollConsumerProperties(Map<String, Object> options) {
        Object schedulerKey;
        Map schedulerProperties;
        if (!options.isEmpty() && !(schedulerProperties = PropertiesHelper.extractProperties(options, (String)"scheduler.")).isEmpty()) {
            this.setSchedulerProperties(schedulerProperties);
        }
        if ((schedulerKey = options.getOrDefault("scheduler", this.scheduler)) != null) {
            if ("spring".equals(schedulerKey)) {
                try {
                    Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(SPRING_SCHEDULER, ScheduledPollConsumerScheduler.class);
                    this.consumerScheduler = (ScheduledPollConsumerScheduler)this.getCamelContext().getInjector().newInstance(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot load org.apache.camel.spring.pollingconsumer.SpringScheduledPollConsumerScheduler from classpath. Make sure camel-spring.jar is on the classpath.", e);
                }
            } else if ("quartz".equals(schedulerKey)) {
                try {
                    Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(QUARTZ_SCHEDULER, ScheduledPollConsumerScheduler.class);
                    this.consumerScheduler = (ScheduledPollConsumerScheduler)this.getCamelContext().getInjector().newInstance(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot load org.apache.camel.pollconsumer.quartz.QuartzScheduledPollConsumerScheduler from classpath. Make sure camel-quartz.jar is on the classpath.", e);
                }
            } else if (!"none".equals(schedulerKey)) {
                if (schedulerKey instanceof String) {
                    String str = schedulerKey.toString();
                    if (EndpointHelper.isReferenceParameter(str)) {
                        str = str.substring(1);
                    }
                    this.consumerScheduler = CamelContextHelper.mandatoryLookup(this.getCamelContext(), str, ScheduledPollConsumerScheduler.class);
                } else if (schedulerKey instanceof ScheduledPollConsumerScheduler) {
                    this.consumerScheduler = (ScheduledPollConsumerScheduler)schedulerKey;
                } else {
                    throw new IllegalArgumentException("Scheduler must either be a reference to a custom scheduler or an ScheduledPollConsumerScheduler type, was: " + schedulerKey.getClass().getName());
                }
            }
        }
    }

    protected void doConfigureConsumer(Consumer consumer) {
        if (consumer instanceof ScheduledPollConsumer) {
            long value;
            ScheduledPollConsumer spc = (ScheduledPollConsumer)consumer;
            spc.setBackoffErrorThreshold(this.backoffErrorThreshold);
            spc.setBackoffIdleThreshold(this.backoffIdleThreshold);
            spc.setBackoffMultiplier(this.backoffMultiplier);
            spc.setRepeatCount(this.repeatCount);
            if (this.delay < 0L) {
                value = this.timeUnit.convert(500L, TimeUnit.MILLISECONDS);
                if (value <= 0L) {
                    value = 1L;
                }
                spc.setDelay(value);
            } else {
                spc.setDelay(this.delay);
            }
            spc.setGreedy(this.greedy);
            if (this.initialDelay < 0L) {
                value = this.timeUnit.convert(1000L, TimeUnit.MILLISECONDS);
                spc.setInitialDelay(value);
            } else {
                spc.setInitialDelay(this.initialDelay);
            }
            spc.setPollStrategy(this.pollStrategy);
            spc.setRunLoggingLevel(this.runLoggingLevel);
            spc.setScheduledExecutorService(this.scheduledExecutorService);
            spc.setSendEmptyMessageWhenIdle(this.sendEmptyMessageWhenIdle);
            spc.setTimeUnit(this.timeUnit);
            spc.setUseFixedDelay(this.useFixedDelay);
            spc.setStartScheduler(this.startScheduler);
            spc.setScheduler(this.consumerScheduler);
            spc.setSchedulerProperties(this.schedulerProperties);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean isStartScheduler() {
        return this.startScheduler;
    }

    public void setStartScheduler(boolean startScheduler) {
        this.startScheduler = startScheduler;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDefaultDelay() {
        return 500L;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public LoggingLevel getRunLoggingLevel() {
        return this.runLoggingLevel;
    }

    public void setRunLoggingLevel(LoggingLevel runLoggingLevel) {
        this.runLoggingLevel = runLoggingLevel;
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.sendEmptyMessageWhenIdle;
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.sendEmptyMessageWhenIdle = sendEmptyMessageWhenIdle;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public void setScheduler(Object schedulerName) {
        this.scheduler = schedulerName;
    }

    public Object getScheduler() {
        return this.scheduler;
    }

    public Map<String, Object> getSchedulerProperties() {
        return this.schedulerProperties;
    }

    public void setSchedulerProperties(Map<String, Object> schedulerProperties) {
        this.schedulerProperties = schedulerProperties;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public int getBackoffIdleThreshold() {
        return this.backoffIdleThreshold;
    }

    public void setBackoffIdleThreshold(int backoffIdleThreshold) {
        this.backoffIdleThreshold = backoffIdleThreshold;
    }

    public int getBackoffErrorThreshold() {
        return this.backoffErrorThreshold;
    }

    public void setBackoffErrorThreshold(int backoffErrorThreshold) {
        this.backoffErrorThreshold = backoffErrorThreshold;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }
}

