/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.services;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.camel.test.infra.aws.common.services.AWSService;
import org.apache.camel.test.infra.aws2.services.AWSTestServices;
import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;

public final class AWSServiceFactory {
    private AWSServiceFactory() {
    }

    public static <T extends AWSService> SimpleTestServiceBuilder<T> builder() {
        return new SimpleTestServiceBuilder("aws");
    }

    private static AWSService createService(Supplier<AWSService> supplier) {
        return (AWSService)AWSServiceFactory.builder().addRemoteMapping(AWSTestServices.AWSRemoteTestService::new).addLocalMapping(supplier).withPropertyNameFormat("%s-service.instance.type").build();
    }

    public static AWSService createKinesisService() {
        return (AWSService)AWSServiceFactory.builder().addRemoteMapping(AWSTestServices.AWSRemoteTestService::new).addLocalMapping(AWSTestServices.AWSKinesisLocalContainerTestService::new).withPropertyNameFormat("%s-service.kinesis.instance.type").build();
    }

    public static AWSService createSQSService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSSQSLocalContainerTestService::new);
    }

    public static AWSService createS3Service() {
        return AWSServiceFactory.createService(AWSTestServices.AWSS3LocalContainerTestService::new);
    }

    public static AWSService createSNSService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSSNSLocalContainerTestService::new);
    }

    public static AWSService createConfigService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSConfigLocalContainerTestService::new);
    }

    public static AWSService createCloudWatchService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSCloudWatchLocalContainerTestService::new);
    }

    public static AWSService createEC2Service() {
        return AWSServiceFactory.createService(AWSTestServices.AWSEC2LocalContainerTestService::new);
    }

    public static AWSService createEventBridgeService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSEventBridgeLocalContainerTestService::new);
    }

    public static AWSService createIAMService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSIAMLocalContainerTestService::new);
    }

    public static AWSService createKMSService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSKMSLocalContainerTestService::new);
    }

    public static AWSService createLambdaService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSLambdaLocalContainerTestService::new);
    }

    public static AWSService createSTSService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSSTSLocalContainerTestService::new);
    }

    public static AWSService createDynamodbService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSDynamodbLocalContainerTestService::new);
    }

    public static AWSService createSecretsManagerService() {
        return AWSServiceFactory.createService(AWSTestServices.AWSSecretsManagerLocalContainerTestService::new);
    }

    public static AWSService createSingletonDynamoDBService() {
        return SingletonServiceHolder.getInstance(new AWSTestServices.AWSDynamodbLocalContainerTestService(), "dynamoDB");
    }

    public static AWSService createSingletonS3Service() {
        return SingletonServiceHolder.getInstance(new AWSTestServices.AWSS3LocalContainerTestService(), "s3");
    }

    public static AWSService createSingletonSQSService() {
        return SingletonServiceHolder.getInstance(new AWSTestServices.AWSSQSLocalContainerTestService(), "sqs");
    }

    public static AWSService createSingletonEventBridgeService() {
        return SingletonServiceHolder.getInstance(new AWSTestServices.AWSEventBridgeLocalContainerTestService(), "eventBridge");
    }

    public static AWSService createSingletonKinesisService() {
        return SingletonServiceHolder.getInstance(new AWSTestServices.AWSKinesisLocalContainerTestService(), "kinesis");
    }

    private static class SingletonServiceHolder {
        private static final Map<String, AWSService> INSTANCES_HOLDER = new ConcurrentHashMap<String, AWSService>();

        private SingletonServiceHolder() {
        }

        public static synchronized AWSService getInstance(AWSService service, String name) {
            if (INSTANCES_HOLDER.get(name) == null) {
                SimpleTestServiceBuilder instance = AWSServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonAWSService(service, name)).addRemoteMapping(AWSTestServices.AWSRemoteTestService::new).build();
                INSTANCES_HOLDER.put(name, (AWSService)instance.build());
            }
            return INSTANCES_HOLDER.get(name);
        }
    }

    private static class SingletonAWSService
    extends SingletonService<AWSService>
    implements AWSService {
        public SingletonAWSService(AWSService service, String name) {
            super((InfrastructureService)service, name);
        }

        public Properties getConnectionProperties() {
            return ((AWSService)this.getService()).getConnectionProperties();
        }
    }
}

