/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.http;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketTestClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketTestClient.class);
    private final List<Object> received = new ArrayList<Object>();
    private final HttpClient modernClient;
    private final String url;
    private CountDownLatch latch;
    private WebSocket websocket;

    public WebsocketTestClient(String url) {
        this(url, 1);
    }

    public WebsocketTestClient(String url, int count) {
        this(url, count, HttpClient.newBuilder());
    }

    public WebsocketTestClient(String url, int count, HttpClient.Builder builder) {
        this.latch = new CountDownLatch(count);
        this.modernClient = builder.build();
        this.url = url;
    }

    public WebsocketTestClient(String url, int count, SSLContext context) {
        this.latch = new CountDownLatch(count);
        this.modernClient = HttpClient.newBuilder().sslContext(context).build();
        this.url = url;
    }

    public void connect() {
        this.websocket = this.modernClient.newWebSocketBuilder().buildAsync(URI.create(this.url), new TestWebSocketListener()).join();
    }

    public void sendTextMessage(String message) {
        this.websocket.sendText(message, true);
    }

    public void sendBytesMessage(byte[] message) {
        this.websocket.sendBinary(ByteBuffer.wrap(message), true);
    }

    public boolean await(int secs) throws InterruptedException {
        return this.await(secs, TimeUnit.SECONDS);
    }

    public boolean await(int duration, TimeUnit timeUnit) throws InterruptedException {
        return this.latch.await(duration, timeUnit);
    }

    public void reset(int count) {
        this.latch = new CountDownLatch(count);
        this.received.clear();
    }

    public List<Object> getReceived() {
        return Collections.unmodifiableList(this.received);
    }

    public <T> List<T> getReceived(Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : this.received) {
            list.add(WebsocketTestClient.getValue(o, cls));
        }
        return list;
    }

    private static <T> T getValue(Object o, Class<T> cls) {
        if (cls.isInstance(o)) {
            return (T)o;
        }
        if (cls == String.class) {
            if (o instanceof byte[]) {
                return (T)new String((byte[])o);
            }
            return (T)o.toString();
        }
        if (cls == byte[].class && o instanceof String) {
            return (T)((String)o).getBytes();
        }
        return null;
    }

    public void close() {
        this.websocket.sendClose(1000, "ok");
    }

    private class TestWebSocketListener
    implements WebSocket.Listener {
        private TestWebSocketListener() {
        }

        @Override
        public void onOpen(WebSocket websocket) {
            LOG.info("[ws] opened");
            websocket.request(1L);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            LOG.info("[ws] closed");
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            LOG.error("[ws] error: {}", (Object)error.getMessage(), (Object)error);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            String message = this.readString(data);
            WebsocketTestClient.this.received.add(message.getBytes());
            LOG.info("[ws] received bytes --> {}", (Object)message);
            WebsocketTestClient.this.latch.countDown();
            return WebSocket.Listener.super.onBinary(webSocket, data, last);
        }

        private String readString(ByteBuffer data) {
            int remaining = data.remaining();
            byte[] tmp = new byte[remaining];
            data.get(tmp);
            return new String(tmp);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            String message = data.toString();
            WebsocketTestClient.this.received.add(message);
            LOG.info("[ws] received --> {}", (Object)message);
            WebsocketTestClient.this.latch.countDown();
            return WebSocket.Listener.super.onText(webSocket, data, last);
        }
    }
}

