/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public final class ContainerEnvironmentUtil {
    public static final String STARTUP_ATTEMPTS_PROPERTY = ".startup.attempts";
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEnvironmentUtil.class);
    private static boolean dockerAvailable;
    private static boolean environmentCheckState;

    private ContainerEnvironmentUtil() {
    }

    public static synchronized boolean isDockerAvailable() {
        if (!environmentCheckState) {
            try {
                dockerAvailable = DockerClientFactory.instance().isDockerAvailable();
                if (!dockerAvailable) {
                    LOG.warn("Docker environment is not available");
                }
            }
            catch (Exception e) {
                LOG.error("Failed to evaluate whether the docker environment is available: {}", (Object)e.getMessage(), (Object)e);
                LOG.warn("Turning off container-based tests because docker does not seem to be working correctly");
                dockerAvailable = false;
            }
            environmentCheckState = true;
        }
        return dockerAvailable;
    }

    public static void configureContainerStartup(GenericContainer<?> container, String property, int defaultValue) {
        int startupAttempts = Integer.valueOf(System.getProperty(property, String.valueOf(defaultValue)));
        container.setStartupAttempts(startupAttempts);
    }
}

