/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.cli.transport.FramedTransportFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.stress.Stress;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class Session
implements Serializable {
    public static final Options availableOptions = new Options();
    public static final String KEYSPACE_NAME = "Keyspace1";
    public static final String DEFAULT_COMPARATOR = "AsciiType";
    public static final String DEFAULT_VALIDATOR = "BytesType";
    private static InetAddress localInetAddress;
    public final AtomicInteger operations = new AtomicInteger();
    public final AtomicInteger keys = new AtomicInteger();
    public final Timer latency = Metrics.newTimer(Session.class, (String)"latency");
    private static final String SSL_TRUSTSTORE = "truststore";
    private static final String SSL_TRUSTSTORE_PW = "truststore-password";
    private static final String SSL_PROTOCOL = "ssl-protocol";
    private static final String SSL_ALGORITHM = "ssl-alg";
    private static final String SSL_STORE_TYPE = "store-type";
    private static final String SSL_CIPHER_SUITES = "ssl-ciphers";
    private int numKeys;
    private int numDifferentKeys = this.numKeys = 1000000;
    private float skipKeys = 0.0f;
    private int threads = 50;
    private int columns = 5;
    private int columnSize = 34;
    private int cardinality = 50;
    public String[] nodes = new String[]{"127.0.0.1"};
    private boolean random = false;
    private int retryTimes = 10;
    public int port = 9160;
    private int superColumns = 1;
    private String compression = null;
    private String compactionStrategy = null;
    private String username = null;
    private String password = null;
    private int progressInterval = 10;
    private int keysPerCall = 1000;
    private boolean replicateOnWrite = true;
    private boolean ignoreErrors = false;
    private boolean enable_cql = false;
    private boolean use_prepared = false;
    private boolean trace = false;
    public boolean use_native_protocol = false;
    private double maxOpsPerSecond = Double.MAX_VALUE;
    private final String outFileName;
    private IndexType indexType = null;
    private Stress.Operations operation = Stress.Operations.INSERT;
    private ColumnFamilyType columnFamilyType = ColumnFamilyType.Standard;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private String replicationStrategy = "org.apache.cassandra.locator.SimpleStrategy";
    private Map<String, String> replicationStrategyOptions = new HashMap<String, String>();
    public final List<ByteBuffer> columnNames;
    public String cqlVersion;
    public final boolean averageSizeValues;
    protected int mean;
    protected float sigma;
    public final InetAddress sendToDaemon;
    public final String comparator;
    public final boolean timeUUIDComparator;
    public double traceProbability = 0.0;
    public EncryptionOptions encOptions = new EncryptionOptions.ClientEncryptionOptions();
    public TTransportFactory transportFactory = new FramedTransportFactory();

    public Session(String[] arguments) throws IllegalArgumentException, SyntaxException {
        float STDev = 0.1f;
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(availableOptions, arguments);
            if (cmd.getArgs().length > 0) {
                System.err.println("Application does not allow arbitrary arguments: " + StringUtils.join((Collection)cmd.getArgList(), (String)", "));
                System.exit(1);
            }
            if (cmd.hasOption("h")) {
                throw new IllegalArgumentException("help");
            }
            if (cmd.hasOption("n")) {
                this.numKeys = Integer.parseInt(cmd.getOptionValue("n"));
            }
            this.numDifferentKeys = cmd.hasOption("F") ? Integer.parseInt(cmd.getOptionValue("F")) : this.numKeys;
            if (cmd.hasOption("N")) {
                this.skipKeys = Float.parseFloat(cmd.getOptionValue("N"));
            }
            if (cmd.hasOption("t")) {
                this.threads = Integer.parseInt(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("c")) {
                this.columns = Integer.parseInt(cmd.getOptionValue("c"));
            }
            if (cmd.hasOption("S")) {
                this.columnSize = Integer.parseInt(cmd.getOptionValue("S"));
            }
            if (cmd.hasOption("C")) {
                this.cardinality = Integer.parseInt(cmd.getOptionValue("C"));
            }
            if (cmd.hasOption("d")) {
                this.nodes = cmd.getOptionValue("d").split(",");
            }
            if (cmd.hasOption("D")) {
                try {
                    String node = null;
                    ArrayList<String> tmpNodes = new ArrayList<String>();
                    BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(cmd.getOptionValue("D"))));
                    while ((node = in.readLine()) != null) {
                        if (node.length() <= 0) continue;
                        tmpNodes.add(node);
                    }
                    this.nodes = tmpNodes.toArray(new String[tmpNodes.size()]);
                    in.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            if (cmd.hasOption("s")) {
                STDev = Float.parseFloat(cmd.getOptionValue("s"));
            }
            if (cmd.hasOption("r")) {
                this.random = true;
            }
            String string = this.outFileName = cmd.hasOption("f") ? cmd.getOptionValue("f") : null;
            if (cmd.hasOption("p")) {
                this.port = Integer.parseInt(cmd.getOptionValue("p"));
            }
            if (cmd.hasOption("o")) {
                this.operation = Stress.Operations.valueOf(cmd.getOptionValue("o").toUpperCase());
            }
            if (cmd.hasOption("u")) {
                this.superColumns = Integer.parseInt(cmd.getOptionValue("u"));
            }
            if (cmd.hasOption("y")) {
                this.columnFamilyType = ColumnFamilyType.valueOf((String)cmd.getOptionValue("y"));
            }
            if (cmd.hasOption("K")) {
                this.retryTimes = Integer.valueOf(cmd.getOptionValue("K"));
                if (this.retryTimes <= 0) {
                    throw new RuntimeException("--keep-trying option value should be > 0");
                }
            }
            if (cmd.hasOption("k")) {
                this.retryTimes = 1;
                this.ignoreErrors = true;
            }
            if (cmd.hasOption("i")) {
                this.progressInterval = Integer.parseInt(cmd.getOptionValue("i"));
            }
            if (cmd.hasOption("g")) {
                this.keysPerCall = Integer.parseInt(cmd.getOptionValue("g"));
            }
            if (cmd.hasOption("th")) {
                this.maxOpsPerSecond = Double.parseDouble(cmd.getOptionValue("th"));
            }
            if (cmd.hasOption("e")) {
                this.consistencyLevel = ConsistencyLevel.valueOf((String)cmd.getOptionValue("e").toUpperCase());
            }
            if (cmd.hasOption("x")) {
                this.indexType = IndexType.valueOf((String)cmd.getOptionValue("x").toUpperCase());
            }
            if (cmd.hasOption("R")) {
                this.replicationStrategy = cmd.getOptionValue("R");
            }
            if (cmd.hasOption("l")) {
                this.replicationStrategyOptions.put("replication_factor", String.valueOf(Integer.parseInt(cmd.getOptionValue("l"))));
            } else if (this.replicationStrategy.endsWith("SimpleStrategy")) {
                this.replicationStrategyOptions.put("replication_factor", "1");
            }
            if (cmd.hasOption("L")) {
                this.enable_cql = true;
                this.cqlVersion = "2.0.0";
            }
            if (cmd.hasOption("L3")) {
                this.enable_cql = true;
                this.cqlVersion = "3.0.0";
            }
            if (cmd.hasOption("b")) {
                if (!this.enable_cql || !this.cqlVersion.startsWith("3")) {
                    throw new IllegalArgumentException("Cannot use binary protocol without -L3");
                }
                this.use_native_protocol = true;
            }
            if (cmd.hasOption("P")) {
                if (!this.enable_cql) {
                    System.err.println("-P/--use-prepared-statements is only applicable with CQL (-L/--enable-cql)");
                    System.exit(-1);
                }
                this.use_prepared = true;
            }
            if (cmd.hasOption("O")) {
                String[] pairs;
                for (String pair : pairs = StringUtils.split((String)cmd.getOptionValue("O"), (char)',')) {
                    String[] keyAndValue = StringUtils.split((String)pair, (char)':');
                    if (keyAndValue.length != 2) {
                        throw new RuntimeException("Invalid --strategy-properties value.");
                    }
                    this.replicationStrategyOptions.put(keyAndValue[0], keyAndValue[1]);
                }
            }
            if (cmd.hasOption("W")) {
                this.replicateOnWrite = false;
            }
            if (cmd.hasOption("I")) {
                this.compression = cmd.getOptionValue("I");
            }
            this.averageSizeValues = cmd.hasOption("V");
            try {
                this.sendToDaemon = cmd.hasOption("send-to") ? InetAddress.getByName(cmd.getOptionValue("send-to")) : null;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            if (cmd.hasOption("Q")) {
                AbstractType comparator = TypeParser.parse((String)DEFAULT_COMPARATOR);
                String[] names = StringUtils.split((String)cmd.getOptionValue("Q"), (String)",");
                this.columnNames = new ArrayList<ByteBuffer>(names.length);
                for (String columnName : names) {
                    this.columnNames.add(comparator.fromString(columnName));
                }
            } else {
                this.columnNames = null;
            }
            if (cmd.hasOption("Z")) {
                this.compactionStrategy = cmd.getOptionValue("Z");
                try {
                    CFMetaData.createCompactionStrategy((String)this.compactionStrategy);
                }
                catch (ConfigurationException e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
            }
            if (cmd.hasOption("U")) {
                AbstractType parsed = null;
                try {
                    parsed = TypeParser.parse((String)cmd.getOptionValue("U"));
                }
                catch (ConfigurationException e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
                this.comparator = cmd.getOptionValue("U");
                this.timeUUIDComparator = parsed instanceof TimeUUIDType;
                if (!(parsed instanceof TimeUUIDType || parsed instanceof AsciiType || parsed instanceof UTF8Type)) {
                    System.err.println("Currently supported types are: TimeUUIDType, AsciiType, UTF8Type.");
                    System.exit(1);
                }
            } else {
                this.comparator = null;
                this.timeUUIDComparator = false;
            }
            if (cmd.hasOption(SSL_TRUSTSTORE)) {
                this.encOptions.truststore = cmd.getOptionValue(SSL_TRUSTSTORE);
            }
            if (cmd.hasOption(SSL_TRUSTSTORE_PW)) {
                this.encOptions.truststore_password = cmd.getOptionValue(SSL_TRUSTSTORE_PW);
            }
            if (cmd.hasOption(SSL_PROTOCOL)) {
                this.encOptions.protocol = cmd.getOptionValue(SSL_PROTOCOL);
            }
            if (cmd.hasOption(SSL_ALGORITHM)) {
                this.encOptions.algorithm = cmd.getOptionValue(SSL_ALGORITHM);
            }
            if (cmd.hasOption(SSL_STORE_TYPE)) {
                this.encOptions.store_type = cmd.getOptionValue(SSL_STORE_TYPE);
            }
            if (cmd.hasOption(SSL_CIPHER_SUITES)) {
                this.encOptions.cipher_suites = cmd.getOptionValue(SSL_CIPHER_SUITES).split(",");
            }
            if (cmd.hasOption("tf")) {
                this.transportFactory = this.validateAndSetTransportFactory(cmd.getOptionValue("tf"));
            }
            if (cmd.hasOption("un")) {
                this.username = cmd.getOptionValue("un");
            }
            if (cmd.hasOption("pw")) {
                this.password = cmd.getOptionValue("pw");
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.mean = this.numDifferentKeys / 2;
        this.sigma = (float)this.numDifferentKeys * STDev;
    }

    private TTransportFactory validateAndSetTransportFactory(String transportFactory) {
        try {
            Class<?> factory = Class.forName(transportFactory);
            if (!TTransportFactory.class.isAssignableFrom(factory)) {
                throw new IllegalArgumentException(String.format("transport factory '%s' not derived from TTransportFactory", transportFactory));
            }
            return (TTransportFactory)factory.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create a transport factory '%s'.", transportFactory), e);
        }
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getColumnsPerKey() {
        return this.columns;
    }

    public ColumnFamilyType getColumnFamilyType() {
        return this.columnFamilyType;
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public int getNumDifferentKeys() {
        return this.numDifferentKeys;
    }

    public int getThreads() {
        return this.threads;
    }

    public double getMaxOpsPerSecond() {
        return this.maxOpsPerSecond;
    }

    public float getSkipKeys() {
        return this.skipKeys;
    }

    public int getSuperColumns() {
        return this.superColumns;
    }

    public int getKeysPerThread() {
        return this.numKeys / this.threads;
    }

    public int getTotalKeysLength() {
        return Integer.toString(this.numDifferentKeys).length();
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public Stress.Operations getOperation() {
        return this.operation;
    }

    public PrintStream getOutputStream() {
        try {
            return this.outFileName == null ? System.out : new PrintStream(new FileOutputStream(this.outFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public int getProgressInterval() {
        return this.progressInterval;
    }

    public boolean useRandomGenerator() {
        return this.random;
    }

    public int getKeysPerCall() {
        return this.keysPerCall;
    }

    public int getMean() {
        return this.mean;
    }

    public float getSigma() {
        return this.sigma;
    }

    public boolean isCQL() {
        return this.enable_cql;
    }

    public boolean usePreparedStatements() {
        return this.use_prepared;
    }

    public void createKeySpaces() {
        KsDef keyspace = new KsDef();
        String defaultComparator = this.comparator == null ? DEFAULT_COMPARATOR : this.comparator;
        CfDef standardCfDef = new CfDef(KEYSPACE_NAME, "Standard1");
        HashMap<String, String> compressionOptions = new HashMap<String, String>();
        if (this.compression != null) {
            compressionOptions.put("sstable_compression", this.compression);
        }
        standardCfDef.setComparator_type(defaultComparator).setDefault_validation_class(DEFAULT_VALIDATOR).setCompression_options(compressionOptions);
        if (!this.timeUUIDComparator) {
            for (int i = 0; i < this.getColumnsPerKey(); ++i) {
                standardCfDef.addToColumn_metadata(new ColumnDef(ByteBufferUtil.bytes((String)("C" + i)), DEFAULT_VALIDATOR));
            }
        }
        if (this.indexType != null) {
            ColumnDef standardColumn = new ColumnDef(ByteBufferUtil.bytes((String)"C1"), DEFAULT_VALIDATOR);
            standardColumn.setIndex_type(this.indexType).setIndex_name("Idx1");
            standardCfDef.setColumn_metadata(Arrays.asList(standardColumn));
        }
        CfDef superCfDef = new CfDef(KEYSPACE_NAME, "Super1").setColumn_type("Super");
        superCfDef.setComparator_type(DEFAULT_COMPARATOR).setSubcomparator_type(defaultComparator).setDefault_validation_class(DEFAULT_VALIDATOR).setCompression_options(compressionOptions);
        CfDef counterCfDef = new CfDef(KEYSPACE_NAME, "Counter1").setComparator_type(defaultComparator).setComparator_type(defaultComparator).setDefault_validation_class("CounterColumnType").setReplicate_on_write(this.replicateOnWrite).setCompression_options(compressionOptions);
        CfDef counterSuperCfDef = new CfDef(KEYSPACE_NAME, "SuperCounter1").setComparator_type(defaultComparator).setDefault_validation_class("CounterColumnType").setReplicate_on_write(this.replicateOnWrite).setColumn_type("Super").setCompression_options(compressionOptions);
        keyspace.setName(KEYSPACE_NAME);
        keyspace.setStrategy_class(this.replicationStrategy);
        if (!this.replicationStrategyOptions.isEmpty()) {
            keyspace.setStrategy_options(this.replicationStrategyOptions);
        }
        if (this.compactionStrategy != null) {
            standardCfDef.setCompaction_strategy(this.compactionStrategy);
            superCfDef.setCompaction_strategy(this.compactionStrategy);
            counterCfDef.setCompaction_strategy(this.compactionStrategy);
            counterSuperCfDef.setCompaction_strategy(this.compactionStrategy);
        }
        keyspace.setCf_defs(new ArrayList<CfDef>(Arrays.asList(standardCfDef, superCfDef, counterCfDef, counterSuperCfDef)));
        CassandraClient client = this.getClient(false);
        try {
            client.system_add_keyspace(keyspace);
            client.set_cql_version("3.0.0");
            client.set_keyspace(KEYSPACE_NAME);
            client.execute_cql3_query(this.createCounterCFStatementForCQL3(), Compression.NONE, ConsistencyLevel.ONE);
            if (this.enable_cql) {
                client.set_cql_version(this.cqlVersion);
            }
            System.out.println(String.format("Created keyspaces. Sleeping %ss for propagation.", this.nodes.length));
            Thread.sleep(this.nodes.length * 1000);
        }
        catch (InvalidRequestException e) {
            System.err.println("Unable to create stress keyspace: " + e.getWhy());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public CassandraClient getClient() {
        return this.getClient(true);
    }

    public CassandraClient getClient(boolean setKeyspace) {
        String currentNode = this.nodes[Stress.randomizer.nextInt(this.nodes.length)];
        TSocket socket = new TSocket(currentNode, this.port);
        TTransport transport = this.transportFactory.getTransport((TTransport)socket);
        CassandraClient client = new CassandraClient((TProtocol)new TBinaryProtocol(transport));
        try {
            if (!transport.isOpen()) {
                transport.open();
            }
            if (this.enable_cql) {
                client.set_cql_version(this.cqlVersion);
            }
            if (setKeyspace) {
                client.set_keyspace(KEYSPACE_NAME);
            }
            if (this.username != null && this.password != null) {
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put("username", this.username);
                credentials.put("password", this.password);
                AuthenticationRequest authenticationRequest = new AuthenticationRequest(credentials);
                client.login(authenticationRequest);
            }
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (AuthorizationException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return client;
    }

    public SimpleClient getNativeClient() {
        try {
            String currentNode = this.nodes[Stress.randomizer.nextInt(this.nodes.length)];
            SimpleClient client = new SimpleClient(currentNode, 9042);
            client.connect(false);
            client.execute("USE \"Keyspace1\";", org.apache.cassandra.db.ConsistencyLevel.ONE);
            return client;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress == null) {
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress;
    }

    private ByteBuffer createCounterCFStatementForCQL3() {
        StringBuilder counter3 = new StringBuilder("CREATE TABLE \"Counter3\" (KEY blob PRIMARY KEY, ");
        for (int i = 0; i < this.getColumnsPerKey(); ++i) {
            counter3.append("c").append(i).append(" counter");
            if (i == this.getColumnsPerKey() - 1) continue;
            counter3.append(", ");
        }
        counter3.append(");");
        return ByteBufferUtil.bytes((String)counter3.toString());
    }

    static {
        availableOptions.addOption("h", "help", false, "Show this help message and exit");
        availableOptions.addOption("n", "num-keys", true, "Number of keys, default:1000000");
        availableOptions.addOption("F", "num-different-keys", true, "Number of different keys (if < NUM-KEYS, the same key will re-used multiple times), default:NUM-KEYS");
        availableOptions.addOption("N", "skip-keys", true, "Fraction of keys to skip initially, default:0");
        availableOptions.addOption("t", "threads", true, "Number of threads to use, default:50");
        availableOptions.addOption("c", "columns", true, "Number of columns per key, default:5");
        availableOptions.addOption("S", "column-size", true, "Size of column values in bytes, default:34");
        availableOptions.addOption("C", "cardinality", true, "Number of unique values stored in columns, default:50");
        availableOptions.addOption("d", "nodes", true, "Host nodes (comma separated), default:locahost");
        availableOptions.addOption("D", "nodesfile", true, "File containing host nodes (one per line)");
        availableOptions.addOption("s", "stdev", true, "Standard Deviation Factor, default:0.1");
        availableOptions.addOption("r", "random", false, "Use random key generator (STDEV will have no effect), default:false");
        availableOptions.addOption("f", "file", true, "Write output to given file");
        availableOptions.addOption("p", "port", true, "Thrift port, default:9160");
        availableOptions.addOption("o", "operation", true, "Operation to perform (INSERT, READ, RANGE_SLICE, INDEXED_RANGE_SLICE, MULTI_GET, COUNTER_ADD, COUNTER_GET), default:INSERT");
        availableOptions.addOption("u", "supercolumns", true, "Number of super columns per key, default:1");
        availableOptions.addOption("y", "family-type", true, "Column Family Type (Super, Standard), default:Standard");
        availableOptions.addOption("K", "keep-trying", true, "Retry on-going operation N times (in case of failure). positive integer, default:10");
        availableOptions.addOption("k", "keep-going", false, "Ignore errors inserting or reading (when set, --keep-trying has no effect), default:false");
        availableOptions.addOption("i", "progress-interval", true, "Progress Report Interval (seconds), default:10");
        availableOptions.addOption("g", "keys-per-call", true, "Number of keys to get_range_slices or multiget per call, default:1000");
        availableOptions.addOption("l", "replication-factor", true, "Replication Factor to use when creating needed column families, default:1");
        availableOptions.addOption("L", "enable-cql", false, "Perform queries using CQL2 (Cassandra Query Language v 2.0.0)");
        availableOptions.addOption("L3", "enable-cql3", false, "Perform queries using CQL3 (Cassandra Query Language v 3.0.0)");
        availableOptions.addOption("b", "enable-native-protocol", false, "Use the binary native protocol (only work along with -L3)");
        availableOptions.addOption("P", "use-prepared-statements", false, "Perform queries using prepared statements (only applicable to CQL).");
        availableOptions.addOption("e", "consistency-level", true, "Consistency Level to use (ONE, QUORUM, LOCAL_QUORUM, EACH_QUORUM, ALL, ANY), default:ONE");
        availableOptions.addOption("x", "create-index", true, "Type of index to create on needed column families (KEYS)");
        availableOptions.addOption("R", "replication-strategy", true, "Replication strategy to use (only on insert if keyspace does not exist), default:org.apache.cassandra.locator.SimpleStrategy");
        availableOptions.addOption("O", "strategy-properties", true, "Replication strategy properties in the following format <dc_name>:<num>,<dc_name>:<num>,...");
        availableOptions.addOption("W", "no-replicate-on-write", false, "Set replicate_on_write to false for counters. Only counter add with CL=ONE will work");
        availableOptions.addOption("V", "average-size-values", false, "Generate column values of average rather than specific size");
        availableOptions.addOption("T", "send-to", true, "Send this as a request to the stress daemon at specified address.");
        availableOptions.addOption("I", "compression", true, "Specify the compression to use for sstable, default:no compression");
        availableOptions.addOption("Q", "query-names", true, "Comma-separated list of column names to retrieve from each row.");
        availableOptions.addOption("Z", "compaction-strategy", true, "CompactionStrategy to use.");
        availableOptions.addOption("U", "comparator", true, "Column Comparator to use. Currently supported types are: TimeUUIDType, AsciiType, UTF8Type.");
        availableOptions.addOption("tf", "transport-factory", true, "Fully-qualified TTransportFactory class name for creating a connection. Note: For Thrift over SSL, use org.apache.cassandra.stress.SSLTransportFactory.");
        availableOptions.addOption("ts", SSL_TRUSTSTORE, true, "SSL: full path to truststore");
        availableOptions.addOption("tspw", SSL_TRUSTSTORE_PW, true, "SSL: full path to truststore");
        availableOptions.addOption("prtcl", SSL_PROTOCOL, true, "SSL: connections protocol to use (default: TLS)");
        availableOptions.addOption("alg", SSL_ALGORITHM, true, "SSL: algorithm (default: SunX509)");
        availableOptions.addOption("st", SSL_STORE_TYPE, true, "SSL: type of store");
        availableOptions.addOption("ciphers", SSL_CIPHER_SUITES, true, "SSL: comma-separated list of encryption suites to use");
        availableOptions.addOption("th", "throttle", true, "Throttle the total number of operations per second to a maximum amount.");
        availableOptions.addOption("un", "username", true, "Username for authentication.");
        availableOptions.addOption("pw", "password", true, "Password for authentication.");
    }
}

