/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.operations.CQLOperation;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.transport.messages.ResultMessage;

public class CqlCounterAdder
extends CQLOperation {
    private static String cqlQuery = null;

    public CqlCounterAdder(Session client, int idx) {
        super(client, idx);
    }

    @Override
    protected void run(Operation.CQLQueryExecutor executor) throws IOException {
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            throw new RuntimeException("Super columns are not implemented for CQL");
        }
        if (cqlQuery == null) {
            String counterCF = this.session.cqlVersion.startsWith("2") ? "Counter1" : "Counter3";
            StringBuilder query = new StringBuilder("UPDATE ").append(this.wrapInQuotesIfRequired(counterCF));
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(" USING CONSISTENCY ").append(this.session.getConsistencyLevel());
            }
            query.append(" SET ");
            for (int i = 0; i < this.session.getColumnsPerKey(); ++i) {
                if (i > 0) {
                    query.append(",");
                }
                query.append('C').append(i).append("=C").append(i).append("+1");
            }
            query.append(" WHERE KEY=?");
            cqlQuery = query.toString();
        }
        String key = String.format("%0" + this.session.getTotalKeysLength() + "d", this.index);
        List<String> queryParams = Collections.singletonList(this.getUnQuotedCqlBlob(key, this.session.cqlVersion.startsWith("3")));
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                success = executor.execute(cqlQuery, queryParams);
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error incrementing key %s %s%n", this.index, this.session.getRetryTimes(), key, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    @Override
    protected boolean validateThriftResult(CqlResult result) {
        return true;
    }

    @Override
    protected boolean validateNativeResult(ResultMessage result) {
        return true;
    }
}

