/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.operations.CQLOperation;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.UUIDGen;

public class CqlInserter
extends CQLOperation {
    private static List<ByteBuffer> values;
    private static String cqlQuery;

    public CqlInserter(Session client, int idx) {
        super(client, idx);
    }

    @Override
    protected void run(Operation.CQLQueryExecutor executor) throws IOException {
        int i;
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            throw new RuntimeException("Super columns are not implemented for CQL");
        }
        if (values == null) {
            values = this.generateValues();
        }
        if (cqlQuery == null) {
            StringBuilder query = new StringBuilder("UPDATE ").append(this.wrapInQuotesIfRequired("Standard1"));
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(" USING CONSISTENCY ").append(this.session.getConsistencyLevel().toString());
            }
            query.append(" SET ");
            for (i = 0; i < this.session.getColumnsPerKey(); ++i) {
                if (i > 0) {
                    query.append(',');
                }
                if (this.session.timeUUIDComparator) {
                    if (this.session.cqlVersion.startsWith("3")) {
                        throw new UnsupportedOperationException("Cannot use UUIDs in column names with CQL3");
                    }
                    query.append(this.wrapInQuotesIfRequired(UUIDGen.getTimeUUID().toString())).append(" = ?");
                    continue;
                }
                query.append(this.wrapInQuotesIfRequired("C" + i)).append(" = ?");
            }
            query.append(" WHERE KEY=?");
            cqlQuery = query.toString();
        }
        ArrayList<String> queryParms = new ArrayList<String>();
        for (i = 0; i < this.session.getColumnsPerKey(); ++i) {
            queryParms.add(this.getUnQuotedCqlBlob(values.get(i % values.size()).array(), this.session.cqlVersion.startsWith("3")));
        }
        String key = String.format("%0" + this.session.getTotalKeysLength() + "d", this.index);
        queryParms.add(this.getUnQuotedCqlBlob(key, this.session.cqlVersion.startsWith("3")));
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                success = executor.execute(cqlQuery, queryParms);
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error inserting key %s %s%n with query %s", this.index, this.session.getRetryTimes(), key, exceptionMessage == null ? "" : "(" + exceptionMessage + ")", cqlQuery));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    @Override
    protected boolean validateThriftResult(CqlResult result) {
        return true;
    }

    @Override
    protected boolean validateNativeResult(ResultMessage result) {
        return true;
    }

    static {
        cqlQuery = null;
    }
}

