/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.operations.CQLOperation;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.transport.messages.ResultMessage;

public class CqlRangeSlicer
extends CQLOperation {
    private static String cqlQuery = null;
    private int lastRowCount;

    public CqlRangeSlicer(Session client, int idx) {
        super(client, idx);
    }

    @Override
    protected void run(Operation.CQLQueryExecutor executor) throws IOException {
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            throw new RuntimeException("Super columns are not implemented for CQL");
        }
        if (cqlQuery == null) {
            StringBuilder query = new StringBuilder("SELECT FIRST ").append(this.session.getColumnsPerKey()).append(" ''..'' FROM Standard1");
            if (this.session.cqlVersion.startsWith("2")) {
                query.append(" USING CONSISTENCY ").append(this.session.getConsistencyLevel().toString());
            }
            cqlQuery = query.append(" WHERE KEY > ?").toString();
        }
        String key = String.format("%0" + this.session.getTotalKeysLength() + "d", this.index);
        List<String> queryParams = Collections.singletonList(this.getUnQuotedCqlBlob(key, this.session.cqlVersion.startsWith("3")));
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                success = executor.execute(cqlQuery, queryParams);
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error executing range slice with offset %s %s%n", this.index, this.session.getRetryTimes(), key, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndAdd(this.lastRowCount);
        context.stop();
    }

    @Override
    protected boolean validateThriftResult(CqlResult result) {
        this.lastRowCount = result.rows.size();
        return this.lastRowCount != 0;
    }

    @Override
    protected boolean validateNativeResult(ResultMessage result) {
        assert (result instanceof ResultMessage.Rows);
        this.lastRowCount = ((ResultMessage.Rows)result).result.size();
        return this.lastRowCount != 0;
    }
}

