/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IndexedRangeSlicer
extends Operation {
    private static List<ByteBuffer> values = null;

    public IndexedRangeSlicer(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        List results;
        if (values == null) {
            values = this.generateValues();
        }
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        SlicePredicate predicate = new SlicePredicate().setSlice_range(new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, this.session.getColumnsPerKey()));
        ColumnParent parent = new ColumnParent("Standard1");
        int expectedPerValue = this.session.getNumKeys() / values.size();
        ByteBuffer columnName = ByteBufferUtil.bytes((String)"C1");
        String startOffset = String.format(format, 0);
        ByteBuffer value = values.get(1);
        IndexExpression expression = new IndexExpression(columnName, IndexOperator.EQ, value);
        for (int received = 0; received < expectedPerValue; received += results.size()) {
            IndexClause clause = new IndexClause(Arrays.asList(expression), ByteBufferUtil.bytes((String)startOffset), this.session.getKeysPerCall());
            results = null;
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    results = client.get_indexed_slices(parent, clause, predicate, this.session.getConsistencyLevel());
                    success = results.size() != 0;
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error on calling get_indexed_slices for offset %s %s%n", this.index, this.session.getRetryTimes(), startOffset, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            startOffset = String.format(format, 1 + this.getMaxKey(results));
            this.session.operations.getAndIncrement();
            this.session.keys.getAndAdd(results.size());
            context.stop();
        }
    }

    private int getMaxKey(List<KeySlice> keySlices) {
        byte[] firstKey = keySlices.get(0).getKey();
        int maxKey = ByteBufferUtil.toInt((ByteBuffer)ByteBuffer.wrap(firstKey));
        for (KeySlice k : keySlices) {
            int currentKey = ByteBufferUtil.toInt((ByteBuffer)ByteBuffer.wrap(k.getKey()));
            if (currentKey <= maxKey) continue;
            maxKey = currentKey;
        }
        return maxKey;
    }
}

