/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcFloat
extends AbstractJdbcType<Float> {
    public static final JdbcFloat instance = new JdbcFloat();

    JdbcFloat() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Float obj) {
        return 40;
    }

    @Override
    public int getPrecision(Float obj) {
        return 7;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(Float obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 4) {
            throw new MarshalException("A float is exactly 4 bytes : " + bytes.remaining());
        }
        return Float.valueOf(ByteBufferUtil.toFloat(bytes)).toString();
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public int getJdbcType() {
        return 6;
    }

    @Override
    public Float compose(ByteBuffer bytes) {
        return Float.valueOf(ByteBufferUtil.toFloat(bytes));
    }

    @Override
    public ByteBuffer decompose(Float value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.floatValue());
    }
}

