/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;

class TruncationSerializer
implements IVersionedSerializer<Truncation> {
    TruncationSerializer() {
    }

    @Override
    public void serialize(Truncation t, DataOutput dos, int version) throws IOException {
        dos.writeUTF(t.keyspace);
        dos.writeUTF(t.columnFamily);
    }

    @Override
    public Truncation deserialize(DataInput dis, int version) throws IOException {
        String keyspace = dis.readUTF();
        String columnFamily = dis.readUTF();
        return new Truncation(keyspace, columnFamily);
    }

    @Override
    public long serializedSize(Truncation truncation, int version) {
        return TypeSizes.NATIVE.sizeof(truncation.keyspace) + TypeSizes.NATIVE.sizeof(truncation.columnFamily);
    }
}

