/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.Pair;

public class SSTableBoundedScanner
extends SSTableScanner {
    private final Iterator<Pair<Long, Long>> rangeIterator;
    private Pair<Long, Long> currentRange;

    SSTableBoundedScanner(SSTableReader sstable, boolean skipCache, Iterator<Pair<Long, Long>> rangeIterator) {
        super(sstable, skipCache);
        this.rangeIterator = rangeIterator;
        assert (rangeIterator.hasNext());
        this.currentRange = rangeIterator.next();
        this.dfile.seek((Long)this.currentRange.left);
    }

    @Override
    public void seekTo(RowPosition seekKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new OnDiskAtomIterator[0]).iterator() : new BoundedKeyScanningIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new OnDiskAtomIterator[0]).iterator() : new BoundedKeyScanningIterator();
        }
        return (OnDiskAtomIterator)this.iterator.next();
    }

    protected class BoundedKeyScanningIterator
    extends SSTableScanner.KeyScanningIterator {
        protected BoundedKeyScanningIterator() {
            super(SSTableBoundedScanner.this);
        }

        @Override
        public boolean hasNext() {
            if (!super.hasNext()) {
                return false;
            }
            if (this.finishedAt < (Long)((SSTableBoundedScanner)SSTableBoundedScanner.this).currentRange.right) {
                return true;
            }
            if (SSTableBoundedScanner.this.rangeIterator.hasNext()) {
                SSTableBoundedScanner.this.currentRange = (Pair)SSTableBoundedScanner.this.rangeIterator.next();
                this.finishedAt = (Long)((SSTableBoundedScanner)SSTableBoundedScanner.this).currentRange.left;
                return true;
            }
            return false;
        }
    }
}

