/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipShutdownVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(GossipShutdownVerbHandler.class);

    public void doVerb(MessageIn message, String id) {
        if (!Gossiper.instance.isEnabled()) {
            logger.debug("Ignoring shutdown message from {} because gossip is disabled", (Object)message.from);
            return;
        }
        FailureDetector.instance.forceConviction(message.from);
    }
}

