/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.result;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessor;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;

public final class QueryProcessorFactory {
    private final Method method;

    private QueryProcessorFactory(Method method) {
        this.method = method;
    }

    public static QueryProcessorFactory newInstance(Method method) {
        return new QueryProcessorFactory(method);
    }

    public QueryProcessor build() {
        if (this.returns(QueryResult.class)) {
            return new NoOpQueryProcessor();
        }
        if (this.returns(List.class)) {
            return new ListQueryProcessor();
        }
        if (this.isModifying()) {
            return new ExecuteUpdateQueryProcessor(this.returns(Void.TYPE));
        }
        return new SingleResultQueryProcessor();
    }

    private boolean isModifying() {
        boolean matchesType = Void.TYPE.equals(this.method.getReturnType()) || Integer.TYPE.equals(this.method.getReturnType()) || Integer.class.equals(this.method.getReturnType());
        return this.method.isAnnotationPresent(Modifying.class) && matchesType;
    }

    private boolean returns(Class<?> clazz) {
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    private static final class ExecuteUpdateQueryProcessor
    implements QueryProcessor {
        private final boolean returnsVoid;

        private ExecuteUpdateQueryProcessor(boolean returnsVoid) {
            this.returnsVoid = returnsVoid;
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            int result = query.executeUpdate();
            if (!this.returnsVoid) {
                return result;
            }
            return null;
        }
    }

    private static final class SingleResultQueryProcessor
    implements QueryProcessor {
        private SingleResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            SingleResultType style = context.getSingleResultStyle();
            switch (style) {
                case JPA: {
                    return query.getSingleResult();
                }
                case OPTIONAL: {
                    try {
                        return query.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            }
            List queryResult = query.getResultList();
            return queryResult.size() > 0 ? queryResult.get(0) : null;
        }
    }

    private static final class NoOpQueryProcessor
    implements QueryProcessor {
        private NoOpQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query;
        }
    }

    private static final class ListQueryProcessor
    implements QueryProcessor {
        private ListQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query.getResultList();
        }
    }
}

