/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import org.apache.deltaspike.core.api.lifecycle.Initialized;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.QueryBuilderFactory;
import org.apache.deltaspike.data.impl.handler.CdiQueryContextHolder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.EntityManagerLookup;
import org.apache.deltaspike.data.impl.handler.QueryRunner;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.meta.RepositoryComponents;
import org.apache.deltaspike.data.impl.meta.RepositoryMethod;

@Repository
public class QueryHandler
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(QueryHandler.class.getName());
    @Inject
    private QueryBuilderFactory queryBuilder;
    @Inject
    @Initialized
    private RepositoryComponents components;
    @Inject
    private CdiQueryContextHolder context;
    @Inject
    private EntityManagerLookup entityManagerLookup;
    @Inject
    private QueryRunner runner;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CdiQueryInvocationContext queryContext = null;
        try {
            Object result;
            List candidates = ProxyUtils.getProxyAndBaseTypes(proxy.getClass());
            RepositoryComponent repo = this.components.lookupComponent(candidates);
            RepositoryMethod repoMethod = this.components.lookupMethod(repo.getRepositoryClass(), method);
            queryContext = this.createContext(proxy, method, args, repo, repoMethod);
            QueryBuilder builder = this.queryBuilder.build(repoMethod, queryContext);
            Object object = result = this.runner.executeQuery(builder, queryContext);
            return object;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Query execution error", e);
            if (queryContext != null) {
                throw new QueryInvocationException((Throwable)e, queryContext);
            }
            throw new QueryInvocationException((Throwable)e, proxy.getClass(), method);
        }
        finally {
            this.context.dispose();
        }
    }

    private CdiQueryInvocationContext createContext(Object proxy, Method method, Object[] args, RepositoryComponent repo, RepositoryMethod repoMethod) {
        CdiQueryInvocationContext queryContext = new CdiQueryInvocationContext(proxy, method, args, repoMethod, this.entityManagerLookup.lookupFor(repo));
        queryContext.init();
        this.context.set(queryContext);
        return queryContext;
    }
}

