/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.param;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Query;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;

public abstract class Parameter {
    private static final Logger LOG = Logger.getLogger(Parameter.class.getName());
    protected final Object value;
    protected final int argIndex;
    protected Object mappedValue = null;

    public Parameter(Object value, int argIndex) {
        this.value = value;
        this.argIndex = argIndex;
    }

    public abstract void apply(Query var1);

    public void applyMapper(QueryInOutMapper<?> mapper) {
        if (mapper.mapsParameter(this.value)) {
            this.mappedValue = mapper.mapParameter(this.value);
            LOG.log(Level.FINE, "Converting param {0} to {1}", new Object[]{this.value, this.mappedValue});
        }
    }

    protected Object queryValue() {
        return this.mappedValue != null ? this.mappedValue : this.value;
    }
}

