/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.deltaspike.core.api.literal.DefaultLiteral;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.data.api.EntityManagerResolver;
import org.apache.deltaspike.data.impl.handler.EntityManagerRef;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;

@ApplicationScoped
public class EntityManagerRefLookup {
    @Inject
    @Any
    private Instance<EntityManager> entityManager;
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;

    public EntityManagerRef lookupReference(RepositoryComponent repository) {
        EntityManagerRef ref = new EntityManagerRef();
        if (repository.hasEntityManagerResolver()) {
            ref.setEntityManagerResolverClass(repository.getEntityManagerResolverClass());
            if (repository.isEntityManagerResolverIsNormalScope()) {
                ref.setEntityManagerResolver((EntityManagerResolver)BeanProvider.getContextualReference(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
            } else {
                ref.setEntityManagerResolverDependentProvider((DependentProvider<? extends EntityManagerResolver>)BeanProvider.getDependent(ref.getEntityManagerResolverClass(), (Annotation[])new Annotation[0]));
                ref.setEntityManagerResolver((EntityManagerResolver)ref.getEntityManagerResolverDependentProvider().get());
            }
            ref.setEntityManager(ref.getEntityManagerResolver().resolveEntityManager());
        } else {
            if (this.activeEntityManagerHolder.isSet()) {
                ref.setEntityManager(this.activeEntityManagerHolder.get());
                return ref;
            }
            ref.setEntityManager((EntityManager)this.entityManager.select(new Annotation[]{new DefaultLiteral()}).get());
        }
        if (repository.hasEntityManagerFlushMode()) {
            ref.getEntityManager().setFlushMode(repository.getEntityManagerFlushMode());
        }
        return ref;
    }
}

