/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.core.util.ArraysUtils;
import org.apache.deltaspike.data.api.EntityRepository;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.RequiresTransaction;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.property.query.NamedPropertyCriteria;
import org.apache.deltaspike.data.impl.property.query.PropertyQueries;
import org.apache.deltaspike.data.impl.util.EntityUtils;
import org.apache.deltaspike.data.impl.util.QueryUtils;
import org.apache.deltaspike.data.impl.util.jpa.PersistenceUnitUtilDelegateFactory;
import org.apache.deltaspike.data.spi.DelegateQueryHandler;

public class EntityRepositoryHandler<E, PK extends Serializable>
implements EntityRepository<E, PK>,
DelegateQueryHandler {
    private static final Logger log = Logger.getLogger(EntityRepositoryHandler.class.getName());
    @Inject
    private CdiQueryInvocationContext context;

    @RequiresTransaction
    public E save(E entity) {
        if (this.context.isNew(entity)) {
            this.entityManager().persist(entity);
            return entity;
        }
        return (E)this.entityManager().merge(entity);
    }

    @RequiresTransaction
    public E saveAndFlush(E entity) {
        E result = this.save(entity);
        this.flush();
        return result;
    }

    @RequiresTransaction
    public E saveAndFlushAndRefresh(E entity) {
        E result = this.saveAndFlush(entity);
        this.entityManager().refresh(result);
        return result;
    }

    @RequiresTransaction
    public void refresh(E entity) {
        this.entityManager().refresh(entity);
    }

    public E findBy(PK primaryKey) {
        return (E)this.entityManager().find(this.entityClass(), primaryKey);
    }

    public List<E> findBy(E example, SingularAttribute<E, ?> ... attributes) {
        return this.findBy(example, -1, -1, attributes);
    }

    public List<E> findBy(E example, int start, int max, SingularAttribute<E, ?> ... attributes) {
        return this.executeExampleQuery(example, start, max, false, attributes);
    }

    public List<E> findByLike(E example, SingularAttribute<E, ?> ... attributes) {
        return this.findByLike(example, -1, -1, attributes);
    }

    public List<E> findByLike(E example, int start, int max, SingularAttribute<E, ?> ... attributes) {
        return this.executeExampleQuery(example, start, max, true, attributes);
    }

    public List<E> findAll() {
        return this.context.applyRestrictions((Query)this.entityManager().createQuery(this.allQuery(), this.entityClass())).getResultList();
    }

    public List<E> findAll(int start, int max) {
        TypedQuery query = this.entityManager().createQuery(this.allQuery(), this.entityClass());
        if (start > 0) {
            query.setFirstResult(start);
        }
        if (max > 0) {
            query.setMaxResults(max);
        }
        return this.context.applyRestrictions((Query)query).getResultList();
    }

    public Long count() {
        return (Long)this.context.applyRestrictions((Query)this.entityManager().createQuery(this.countQuery(), Long.class)).getSingleResult();
    }

    public Long count(E example, SingularAttribute<E, ?> ... attributes) {
        return this.executeCountQuery(example, false, attributes);
    }

    public Long countLike(E example, SingularAttribute<E, ?> ... attributes) {
        return this.executeCountQuery(example, true, attributes);
    }

    public PK getPrimaryKey(E entity) {
        return (PK)((Serializable)this.persistenceUnitUtil().getIdentifier(entity));
    }

    @RequiresTransaction
    public void remove(E entity) {
        this.entityManager().remove(entity);
    }

    @RequiresTransaction
    public void removeAndFlush(E entity) {
        this.entityManager().remove(entity);
        this.flush();
    }

    @RequiresTransaction
    public void attachAndRemove(E entity) {
        if (!this.entityManager().contains(entity)) {
            entity = this.entityManager().merge(entity);
        }
        this.remove(entity);
    }

    @RequiresTransaction
    public void flush() {
        this.entityManager().flush();
    }

    public EntityManager entityManager() {
        return this.context.getEntityManager();
    }

    public CriteriaQuery<E> criteriaQuery() {
        return this.entityManager().getCriteriaBuilder().createQuery(this.entityClass());
    }

    public TypedQuery<E> typedQuery(String qlString) {
        return this.entityManager().createQuery(qlString, this.entityClass());
    }

    public Class<E> entityClass() {
        return this.context.getEntityClass();
    }

    public String tableName() {
        return EntityUtils.tableName(this.context.getEntityClass(), this.entityManager());
    }

    public String entityName() {
        return this.context.getRepositoryMethod().getRepository().getRepositoryEntity().getEntityName();
    }

    private String allQuery() {
        return QueryBuilder.selectQuery(this.entityName());
    }

    private String countQuery() {
        return QueryBuilder.countQuery(this.entityName());
    }

    private String exampleQuery(String queryBase, List<Property<Object>> properties, boolean useLikeOperator) {
        StringBuilder jpqlQuery = new StringBuilder(queryBase).append(" where ");
        jpqlQuery.append(this.prepareWhere(properties, useLikeOperator));
        return jpqlQuery.toString();
    }

    private void addParameters(TypedQuery<?> query, E example, List<Property<Object>> properties, boolean useLikeOperator) {
        for (Property<Object> property : properties) {
            property.setAccessible();
            query.setParameter(property.getName(), this.transform(property.getValue(example), useLikeOperator));
        }
    }

    private Object transform(Object value, boolean useLikeOperator) {
        if (value != null && useLikeOperator && QueryUtils.isString(value)) {
            String result = ((String)value).toUpperCase();
            return "%" + result + "%";
        }
        return value;
    }

    private String prepareWhere(List<Property<Object>> properties, boolean useLikeOperator) {
        Iterator<Property<Object>> iterator = properties.iterator();
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            Property<Object> property = iterator.next();
            String name = property.getName();
            if (useLikeOperator && property.getJavaClass().getName().equals(String.class.getName())) {
                result.append("UPPER(e.").append(name).append(") like :").append(name).append(iterator.hasNext() ? " and " : "");
                continue;
            }
            result.append("e.").append(name).append(" = :").append(name).append(iterator.hasNext() ? " and " : "");
        }
        return result.toString();
    }

    private List<String> extractPropertyNames(SingularAttribute<E, ?> ... attributes) {
        ArrayList<String> result = new ArrayList<String>(attributes.length);
        for (SingularAttribute<E, ?> attribute : attributes) {
            result.add(attribute.getName());
        }
        return result;
    }

    private List<Property<Object>> extractProperties(SingularAttribute<E, ?> ... attributes) {
        List<String> names = this.extractPropertyNames(attributes);
        List<Property<Object>> properties = PropertyQueries.createQuery(this.entityClass()).addCriteria(new NamedPropertyCriteria(names.toArray(new String[0]))).getResultList();
        return properties;
    }

    private List<E> executeExampleQuery(E example, int start, int max, boolean useLikeOperator, SingularAttribute<E, ?> ... attributes) {
        if (ArraysUtils.isEmpty((Object[])attributes)) {
            return this.findAll(start, max);
        }
        List<Property<Object>> properties = this.extractProperties(attributes);
        String jpqlQuery = this.exampleQuery(this.allQuery(), properties, useLikeOperator);
        log.log(Level.FINER, "findBy|findByLike: Created query {0}", jpqlQuery);
        TypedQuery query = this.entityManager().createQuery(jpqlQuery, this.entityClass());
        if (start > 0) {
            query.setFirstResult(start);
        }
        if (max > 0) {
            query.setMaxResults(max);
        }
        this.context.applyRestrictions((Query)query);
        this.addParameters(query, example, properties, useLikeOperator);
        return query.getResultList();
    }

    private Long executeCountQuery(E example, boolean useLikeOperator, SingularAttribute<E, ?> ... attributes) {
        if (ArraysUtils.isEmpty((Object[])attributes)) {
            return this.count();
        }
        List<Property<Object>> properties = this.extractProperties(attributes);
        String jpqlQuery = this.exampleQuery(this.countQuery(), properties, useLikeOperator);
        log.log(Level.FINER, "count: Created query {0}", jpqlQuery);
        TypedQuery query = this.entityManager().createQuery(jpqlQuery, Long.class);
        this.addParameters(query, example, properties, useLikeOperator);
        this.context.applyRestrictions((Query)query);
        return (Long)query.getSingleResult();
    }

    private PersistenceUnitUtil persistenceUnitUtil() {
        return PersistenceUnitUtilDelegateFactory.get(this.entityManager());
    }
}

