/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.extractor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.data.impl.meta.RepositoryEntity;
import org.apache.deltaspike.data.impl.meta.extractor.MetadataExtractor;
import org.apache.deltaspike.data.impl.util.EntityUtils;

public class TypeMetadataExtractor
implements MetadataExtractor {
    private static final Logger log = Logger.getLogger(TypeMetadataExtractor.class.getName());

    @Override
    public RepositoryEntity extract(Class<?> repoClass) {
        for (Type inf : repoClass.getGenericInterfaces()) {
            RepositoryEntity result = this.extractFrom(inf);
            if (result == null) continue;
            return result;
        }
        RepositoryEntity result = this.extractFrom(repoClass.getGenericSuperclass());
        if (result != null) {
            return result;
        }
        for (Type intf : repoClass.getGenericInterfaces()) {
            result = this.extractFrom(intf);
            if (result == null) continue;
            return result;
        }
        if (repoClass.getSuperclass() != null) {
            return this.extract(repoClass.getSuperclass());
        }
        return null;
    }

    private RepositoryEntity extractFrom(Type type) {
        log.log(Level.FINER, "extractFrom: type = {0}", type);
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parametrizedType = (ParameterizedType)type;
        Type[] genericTypes = parametrizedType.getActualTypeArguments();
        RepositoryEntity result = null;
        for (int i = 0; i < genericTypes.length; ++i) {
            Type genericType = genericTypes[i];
            if (genericType instanceof Class && EntityUtils.isEntityClass((Class)genericType)) {
                result = new RepositoryEntity((Class)genericType);
                continue;
            }
            if (result == null || !(genericType instanceof Class)) continue;
            result.setPrimaryKeyClass((Class)genericType);
            return result;
        }
        return result;
    }
}

