/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.deltaspike.jpa.impl.transaction.BeanManagedUserTransactionStrategy;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;

@Dependent
@Alternative
public class EnvironmentAwareTransactionStrategy
extends BeanManagedUserTransactionStrategy {
    private static final long serialVersionUID = -4432802805095533499L;
    private static ThreadLocal<Boolean> isJtaModeDetected = new ThreadLocal();

    @Override
    protected EntityManagerEntry createEntityManagerEntry(EntityManager entityManager, Class<? extends Annotation> qualifier) {
        boolean isTransactionTypeJta = false;
        if (isJtaModeDetected.get() == null) {
            try {
                entityManager.getTransaction();
            }
            catch (IllegalStateException e) {
                isTransactionTypeJta = true;
            }
            isJtaModeDetected.set(isTransactionTypeJta);
        } else {
            isTransactionTypeJta = EnvironmentAwareTransactionStrategy.isInJtaTransaction();
        }
        if (isTransactionTypeJta) {
            this.applyTransactionTimeout();
        }
        return new EntityManagerEntry(entityManager, qualifier);
    }

    @Override
    protected void beforeProceed(EntityManagerEntry entityManagerEntry) {
        if (EnvironmentAwareTransactionStrategy.isInJtaTransaction()) {
            super.beforeProceed(entityManagerEntry);
        }
    }

    @Override
    protected EntityTransaction getTransaction(EntityManagerEntry entityManagerEntry) {
        if (EnvironmentAwareTransactionStrategy.isInJtaTransaction()) {
            return super.getTransaction(entityManagerEntry);
        }
        return entityManagerEntry.getEntityManager().getTransaction();
    }

    @Override
    protected void onCloseTransactionScope() {
        super.onCloseTransactionScope();
        isJtaModeDetected.set(null);
        isJtaModeDetected.remove();
    }

    private static boolean isInJtaTransaction() {
        return Boolean.TRUE.equals(isJtaModeDetected.get());
    }
}

