/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import java.lang.reflect.InvocationHandler;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.apache.deltaspike.partialbean.impl.proxy.PartialBeanProxy;
import org.apache.deltaspike.partialbean.impl.proxy.PartialBeanProxyFactory;

class PartialBeanLifecycle<T, H extends InvocationHandler>
implements ContextualLifecycle<T> {
    private final Class<T> proxyClass;
    private final Class<T> partialBeanClass;
    private final Class<H> handlerClass;
    private InjectionTarget<T> injectionTarget;
    private CreationalContext<?> creationalContextOfDependentHandler;

    PartialBeanLifecycle(Class<T> partialBeanClass, Class<H> handlerClass, BeanManager beanManager) {
        this.partialBeanClass = partialBeanClass;
        this.proxyClass = PartialBeanProxyFactory.getProxyClass(partialBeanClass, handlerClass);
        this.handlerClass = handlerClass;
        if (!partialBeanClass.isInterface()) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(this.partialBeanClass);
            this.injectionTarget = beanManager.createInjectionTarget(annotatedType);
        }
    }

    public T create(Bean bean, CreationalContext creationalContext) {
        try {
            T instance = this.proxyClass.newInstance();
            ((PartialBeanProxy)instance).setRedirectInvocationHandler((InvocationHandler)this.createHandlerInstance());
            if (this.injectionTarget != null) {
                this.injectionTarget.inject(instance, creationalContext);
                this.injectionTarget.postConstruct(instance);
            }
            return instance;
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            return null;
        }
    }

    public void destroy(Bean<T> bean, T instance, CreationalContext<T> creationalContext) {
        if (this.injectionTarget != null) {
            this.injectionTarget.preDestroy(instance);
        }
        if (this.creationalContextOfDependentHandler != null) {
            this.creationalContextOfDependentHandler.release();
        }
        creationalContext.release();
    }

    private H createHandlerInstance() {
        Set handlerBeans = BeanProvider.getBeanDefinitions(this.handlerClass, (boolean)false, (boolean)true);
        if (handlerBeans.size() != 1) {
            StringBuilder beanInfo = new StringBuilder();
            for (Bean bean : handlerBeans) {
                if (beanInfo.length() != 0) {
                    beanInfo.append(", ");
                }
                beanInfo.append(bean);
                if (!(bean instanceof PassivationCapable)) continue;
                beanInfo.append(" bean-id: ").append(((PassivationCapable)bean).getId());
            }
            throw new IllegalStateException(handlerBeans.size() + " beans found for " + this.handlerClass + " found beans: " + beanInfo.toString());
        }
        Bean handlerBean = (Bean)handlerBeans.iterator().next();
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)handlerBean);
        InvocationHandler handlerInstance = (InvocationHandler)beanManager.getReference(handlerBean, this.handlerClass, creationalContext);
        if (handlerBean.getScope().equals(Dependent.class)) {
            this.creationalContextOfDependentHandler = creationalContext;
        }
        return (H)handlerInstance;
    }
}

