/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl.interception;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.partialbean.impl.interception.ManualInvocationHandler;
import org.apache.deltaspike.partialbean.impl.interception.ProceedOriginalMethodException;

@Typed
public class ManualInvocationContext<T, H>
implements InvocationContext {
    protected List<Interceptor<H>> interceptors;
    protected int interceptorIndex;
    protected T target;
    protected Method method;
    protected Object[] parameters;
    protected Map<String, Object> contextData;
    protected Object timer;
    protected ManualInvocationHandler manualInvocationHandler;

    public ManualInvocationContext(ManualInvocationHandler manualInvocationHandler, List<Interceptor<H>> interceptors, T target, Method method, Object[] parameters, Object timer) {
        this.manualInvocationHandler = manualInvocationHandler;
        this.interceptors = interceptors;
        this.target = target;
        this.method = method;
        this.parameters = parameters;
        this.timer = timer;
        this.interceptorIndex = 0;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] os) {
        this.parameters = os;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object proceed() throws Exception {
        if (this.interceptors.size() > this.interceptorIndex) {
            Object object;
            block8: {
                CreationalContext creationalContext;
                block9: {
                    Interceptor<H> interceptor = null;
                    creationalContext = null;
                    Object interceptorInstance = null;
                    try {
                        Object value;
                        interceptor = this.interceptors.get(this.interceptorIndex++);
                        creationalContext = BeanManagerProvider.getInstance().getBeanManager().createCreationalContext(interceptor);
                        interceptorInstance = interceptor.create(creationalContext);
                        object = value = interceptor.intercept(InterceptionType.AROUND_INVOKE, interceptorInstance, (InvocationContext)this);
                        if (creationalContext == null) break block8;
                        if (interceptorInstance == null || interceptor == null) break block9;
                    }
                    catch (Exception e) {
                        block10: {
                            Object object2;
                            block11: {
                                block12: {
                                    try {
                                        ProceedOriginalMethodException proceedOriginalMethodException = this.extractProceedOriginalMethodException(e);
                                        if (proceedOriginalMethodException == null) break block10;
                                        object2 = this.manualInvocationHandler.proceedOriginal(this.target, this.method, this.parameters);
                                        if (creationalContext == null) break block11;
                                        if (interceptorInstance == null || interceptor == null) break block12;
                                    }
                                    catch (Throwable throwable) {
                                        if (creationalContext != null) {
                                            if (interceptorInstance != null && interceptor != null) {
                                                interceptor.destroy(interceptorInstance, creationalContext);
                                            }
                                            creationalContext.release();
                                        }
                                        throw throwable;
                                    }
                                    interceptor.destroy(interceptorInstance, creationalContext);
                                }
                                creationalContext.release();
                            }
                            return object2;
                        }
                        throw e;
                    }
                    interceptor.destroy(interceptorInstance, creationalContext);
                }
                creationalContext.release();
            }
            return object;
        }
        Object value = this.manualInvocationHandler.proceedOriginal(this.target, this.method, this.parameters);
        return value;
    }

    protected ProceedOriginalMethodException extractProceedOriginalMethodException(Throwable throwable) {
        if (throwable instanceof ProceedOriginalMethodException) {
            return (ProceedOriginalMethodException)throwable;
        }
        while (throwable.getCause() != null) {
            if (!((throwable = throwable.getCause()) instanceof ProceedOriginalMethodException)) continue;
            return (ProceedOriginalMethodException)throwable;
        }
        return null;
    }

    public Object getTimer() {
        return this.timer;
    }

    public Constructor getConstructor() {
        return null;
    }
}

